/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.transfer.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.transfer.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ImportHostKeyRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String serverId;
    private String hostKeyBody;
    private String description;
    private List<Tag> tags;

    public void setServerId(String serverId) {
        this.serverId = serverId;
    }

    public String getServerId() {
        return this.serverId;
    }

    public ImportHostKeyRequest withServerId(String serverId) {
        this.setServerId(serverId);
        return this;
    }

    public void setHostKeyBody(String hostKeyBody) {
        this.hostKeyBody = hostKeyBody;
    }

    public String getHostKeyBody() {
        return this.hostKeyBody;
    }

    public ImportHostKeyRequest withHostKeyBody(String hostKeyBody) {
        this.setHostKeyBody(hostKeyBody);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public ImportHostKeyRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public ImportHostKeyRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public ImportHostKeyRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getServerId() != null) {
            sb.append("ServerId: ").append(this.getServerId()).append(",");
        }
        if (this.getHostKeyBody() != null) {
            sb.append("HostKeyBody: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportHostKeyRequest)) {
            return false;
        }
        ImportHostKeyRequest other = (ImportHostKeyRequest)obj;
        if (other.getServerId() == null ^ this.getServerId() == null) {
            return false;
        }
        if (other.getServerId() != null && !other.getServerId().equals(this.getServerId())) {
            return false;
        }
        if (other.getHostKeyBody() == null ^ this.getHostKeyBody() == null) {
            return false;
        }
        if (other.getHostKeyBody() != null && !other.getHostKeyBody().equals(this.getHostKeyBody())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getServerId() == null ? 0 : this.getServerId().hashCode());
        hashCode = 31 * hashCode + (this.getHostKeyBody() == null ? 0 : this.getHostKeyBody().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public ImportHostKeyRequest clone() {
        return (ImportHostKeyRequest)super.clone();
    }
}

