/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.transfer.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.transfer.model.S3FileLocation;

@SdkInternalApi
public class S3FileLocationMarshaller {
    private static final MarshallingInfo<String> BUCKET_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Bucket").build();
    private static final MarshallingInfo<String> KEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Key").build();
    private static final MarshallingInfo<String> VERSIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VersionId").build();
    private static final MarshallingInfo<String> ETAG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Etag").build();
    private static final S3FileLocationMarshaller instance = new S3FileLocationMarshaller();

    public static S3FileLocationMarshaller getInstance() {
        return instance;
    }

    public void marshall(S3FileLocation s3FileLocation, ProtocolMarshaller protocolMarshaller) {
        if (s3FileLocation == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)s3FileLocation.getBucket(), BUCKET_BINDING);
            protocolMarshaller.marshall((Object)s3FileLocation.getKey(), KEY_BINDING);
            protocolMarshaller.marshall((Object)s3FileLocation.getVersionId(), VERSIONID_BINDING);
            protocolMarshaller.marshall((Object)s3FileLocation.getEtag(), ETAG_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

