/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.transcribe.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.transcribe.model.SentimentFilter;
import java.util.List;

@SdkInternalApi
public class SentimentFilterMarshaller {
    private static final MarshallingInfo<List> SENTIMENTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Sentiments").build();
    private static final MarshallingInfo<StructuredPojo> ABSOLUTETIMERANGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AbsoluteTimeRange").build();
    private static final MarshallingInfo<StructuredPojo> RELATIVETIMERANGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RelativeTimeRange").build();
    private static final MarshallingInfo<String> PARTICIPANTROLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ParticipantRole").build();
    private static final MarshallingInfo<Boolean> NEGATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Negate").build();
    private static final SentimentFilterMarshaller instance = new SentimentFilterMarshaller();

    public static SentimentFilterMarshaller getInstance() {
        return instance;
    }

    public void marshall(SentimentFilter sentimentFilter, ProtocolMarshaller protocolMarshaller) {
        if (sentimentFilter == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(sentimentFilter.getSentiments(), SENTIMENTS_BINDING);
            protocolMarshaller.marshall((Object)sentimentFilter.getAbsoluteTimeRange(), ABSOLUTETIMERANGE_BINDING);
            protocolMarshaller.marshall((Object)sentimentFilter.getRelativeTimeRange(), RELATIVETIMERANGE_BINDING);
            protocolMarshaller.marshall((Object)sentimentFilter.getParticipantRole(), PARTICIPANTROLE_BINDING);
            protocolMarshaller.marshall((Object)sentimentFilter.getNegate(), NEGATE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

