/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.timestreamwrite;

import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.annotation.NotThreadSafe;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AwsSyncClientBuilder;
import com.amazonaws.endpointdiscovery.DefaultEndpointDiscoveryProviderChain;
import com.amazonaws.endpointdiscovery.EndpointDiscoveryProviderChain;
import com.amazonaws.internal.config.InternalConfig;
import com.amazonaws.services.timestreamwrite.AmazonTimestreamWrite;
import com.amazonaws.services.timestreamwrite.AmazonTimestreamWriteClient;

@NotThreadSafe
public final class AmazonTimestreamWriteClientBuilder
extends AwsSyncClientBuilder<AmazonTimestreamWriteClientBuilder, AmazonTimestreamWrite> {
    private static final ClientConfigurationFactory CLIENT_CONFIG_FACTORY = new ClientConfigurationFactory();
    private static final EndpointDiscoveryProviderChain DEFAULT_ENDPOINT_DISCOVERY_PROVIDER = new DefaultEndpointDiscoveryProviderChain();
    private boolean endpointDiscoveryEnabled = true;
    private boolean endpointDiscoveryDisabled = false;

    public static AmazonTimestreamWriteClientBuilder standard() {
        return new AmazonTimestreamWriteClientBuilder();
    }

    public static AmazonTimestreamWrite defaultClient() {
        return (AmazonTimestreamWrite)AmazonTimestreamWriteClientBuilder.standard().build();
    }

    private AmazonTimestreamWriteClientBuilder() {
        super(CLIENT_CONFIG_FACTORY);
    }

    public AmazonTimestreamWriteClientBuilder enableEndpointDiscovery() {
        this.endpointDiscoveryEnabled = true;
        return this;
    }

    public AmazonTimestreamWriteClientBuilder disableEndpointDiscovery() {
        this.endpointDiscoveryDisabled = true;
        return this;
    }

    private boolean endpointDiscoveryEnabled() {
        Boolean endpointDiscoveryChainSetting = DEFAULT_ENDPOINT_DISCOVERY_PROVIDER.endpointDiscoveryEnabled();
        if (this.endpointDiscoveryDisabled) {
            return false;
        }
        if (this.endpointDiscoveryEnabled) {
            return true;
        }
        if (endpointDiscoveryChainSetting != null && !endpointDiscoveryChainSetting.booleanValue()) {
            return false;
        }
        if (endpointDiscoveryChainSetting != null && endpointDiscoveryChainSetting.booleanValue()) {
            return true;
        }
        return InternalConfig.Factory.getInternalConfig().endpointDiscoveryEnabled();
    }

    protected AmazonTimestreamWrite build(AwsSyncClientParams params) {
        if (this.endpointDiscoveryEnabled() && this.getEndpoint() == null) {
            return new AmazonTimestreamWriteClient(params, true);
        }
        return new AmazonTimestreamWriteClient(params);
    }
}

