/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.taxsettings.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.taxsettings.model.TaxRegistration;
import java.util.List;

@SdkInternalApi
public class TaxRegistrationMarshaller {
    private static final MarshallingInfo<StructuredPojo> ADDITIONALTAXINFORMATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("additionalTaxInformation").build();
    private static final MarshallingInfo<String> CERTIFIEDEMAILID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("certifiedEmailId").build();
    private static final MarshallingInfo<StructuredPojo> LEGALADDRESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("legalAddress").build();
    private static final MarshallingInfo<String> LEGALNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("legalName").build();
    private static final MarshallingInfo<String> REGISTRATIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("registrationId").build();
    private static final MarshallingInfo<String> REGISTRATIONTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("registrationType").build();
    private static final MarshallingInfo<String> SECTOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sector").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").build();
    private static final MarshallingInfo<List> TAXDOCUMENTMETADATAS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("taxDocumentMetadatas").build();
    private static final TaxRegistrationMarshaller instance = new TaxRegistrationMarshaller();

    public static TaxRegistrationMarshaller getInstance() {
        return instance;
    }

    public void marshall(TaxRegistration taxRegistration, ProtocolMarshaller protocolMarshaller) {
        if (taxRegistration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)taxRegistration.getAdditionalTaxInformation(), ADDITIONALTAXINFORMATION_BINDING);
            protocolMarshaller.marshall((Object)taxRegistration.getCertifiedEmailId(), CERTIFIEDEMAILID_BINDING);
            protocolMarshaller.marshall((Object)taxRegistration.getLegalAddress(), LEGALADDRESS_BINDING);
            protocolMarshaller.marshall((Object)taxRegistration.getLegalName(), LEGALNAME_BINDING);
            protocolMarshaller.marshall((Object)taxRegistration.getRegistrationId(), REGISTRATIONID_BINDING);
            protocolMarshaller.marshall((Object)taxRegistration.getRegistrationType(), REGISTRATIONTYPE_BINDING);
            protocolMarshaller.marshall((Object)taxRegistration.getSector(), SECTOR_BINDING);
            protocolMarshaller.marshall((Object)taxRegistration.getStatus(), STATUS_BINDING);
            protocolMarshaller.marshall(taxRegistration.getTaxDocumentMetadatas(), TAXDOCUMENTMETADATAS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

