/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.synthetics.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.synthetics.model.BaseScreenshot;
import java.util.List;

@SdkInternalApi
public class BaseScreenshotMarshaller {
    private static final MarshallingInfo<String> SCREENSHOTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ScreenshotName").build();
    private static final MarshallingInfo<List> IGNORECOORDINATES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IgnoreCoordinates").build();
    private static final BaseScreenshotMarshaller instance = new BaseScreenshotMarshaller();

    public static BaseScreenshotMarshaller getInstance() {
        return instance;
    }

    public void marshall(BaseScreenshot baseScreenshot, ProtocolMarshaller protocolMarshaller) {
        if (baseScreenshot == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)baseScreenshot.getScreenshotName(), SCREENSHOTNAME_BINDING);
            protocolMarshaller.marshall(baseScreenshot.getIgnoreCoordinates(), IGNORECOORDINATES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

