/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.synthetics.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.synthetics.model.S3EncryptionConfig;

@SdkInternalApi
public class S3EncryptionConfigMarshaller {
    private static final MarshallingInfo<String> ENCRYPTIONMODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EncryptionMode").build();
    private static final MarshallingInfo<String> KMSKEYARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KmsKeyArn").build();
    private static final S3EncryptionConfigMarshaller instance = new S3EncryptionConfigMarshaller();

    public static S3EncryptionConfigMarshaller getInstance() {
        return instance;
    }

    public void marshall(S3EncryptionConfig s3EncryptionConfig, ProtocolMarshaller protocolMarshaller) {
        if (s3EncryptionConfig == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)s3EncryptionConfig.getEncryptionMode(), ENCRYPTIONMODE_BINDING);
            protocolMarshaller.marshall((Object)s3EncryptionConfig.getKmsKeyArn(), KMSKEYARN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

