/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.supportapp;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.supportapp.AWSSupportAppAsync;
import com.amazonaws.services.supportapp.AWSSupportAppAsyncClientBuilder;
import com.amazonaws.services.supportapp.AWSSupportAppClient;
import com.amazonaws.services.supportapp.model.CreateSlackChannelConfigurationRequest;
import com.amazonaws.services.supportapp.model.CreateSlackChannelConfigurationResult;
import com.amazonaws.services.supportapp.model.DeleteAccountAliasRequest;
import com.amazonaws.services.supportapp.model.DeleteAccountAliasResult;
import com.amazonaws.services.supportapp.model.DeleteSlackChannelConfigurationRequest;
import com.amazonaws.services.supportapp.model.DeleteSlackChannelConfigurationResult;
import com.amazonaws.services.supportapp.model.DeleteSlackWorkspaceConfigurationRequest;
import com.amazonaws.services.supportapp.model.DeleteSlackWorkspaceConfigurationResult;
import com.amazonaws.services.supportapp.model.GetAccountAliasRequest;
import com.amazonaws.services.supportapp.model.GetAccountAliasResult;
import com.amazonaws.services.supportapp.model.ListSlackChannelConfigurationsRequest;
import com.amazonaws.services.supportapp.model.ListSlackChannelConfigurationsResult;
import com.amazonaws.services.supportapp.model.ListSlackWorkspaceConfigurationsRequest;
import com.amazonaws.services.supportapp.model.ListSlackWorkspaceConfigurationsResult;
import com.amazonaws.services.supportapp.model.PutAccountAliasRequest;
import com.amazonaws.services.supportapp.model.PutAccountAliasResult;
import com.amazonaws.services.supportapp.model.RegisterSlackWorkspaceForOrganizationRequest;
import com.amazonaws.services.supportapp.model.RegisterSlackWorkspaceForOrganizationResult;
import com.amazonaws.services.supportapp.model.UpdateSlackChannelConfigurationRequest;
import com.amazonaws.services.supportapp.model.UpdateSlackChannelConfigurationResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSSupportAppAsyncClient
extends AWSSupportAppClient
implements AWSSupportAppAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSSupportAppAsyncClientBuilder asyncBuilder() {
        return AWSSupportAppAsyncClientBuilder.standard();
    }

    AWSSupportAppAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSSupportAppAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateSlackChannelConfigurationResult> createSlackChannelConfigurationAsync(CreateSlackChannelConfigurationRequest request) {
        return this.createSlackChannelConfigurationAsync(request, null);
    }

    @Override
    public Future<CreateSlackChannelConfigurationResult> createSlackChannelConfigurationAsync(CreateSlackChannelConfigurationRequest request, final AsyncHandler<CreateSlackChannelConfigurationRequest, CreateSlackChannelConfigurationResult> asyncHandler) {
        final CreateSlackChannelConfigurationRequest finalRequest = (CreateSlackChannelConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateSlackChannelConfigurationResult>(){

            @Override
            public CreateSlackChannelConfigurationResult call() throws Exception {
                CreateSlackChannelConfigurationResult result = null;
                try {
                    result = AWSSupportAppAsyncClient.this.executeCreateSlackChannelConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteAccountAliasResult> deleteAccountAliasAsync(DeleteAccountAliasRequest request) {
        return this.deleteAccountAliasAsync(request, null);
    }

    @Override
    public Future<DeleteAccountAliasResult> deleteAccountAliasAsync(DeleteAccountAliasRequest request, final AsyncHandler<DeleteAccountAliasRequest, DeleteAccountAliasResult> asyncHandler) {
        final DeleteAccountAliasRequest finalRequest = (DeleteAccountAliasRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteAccountAliasResult>(){

            @Override
            public DeleteAccountAliasResult call() throws Exception {
                DeleteAccountAliasResult result = null;
                try {
                    result = AWSSupportAppAsyncClient.this.executeDeleteAccountAlias(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteSlackChannelConfigurationResult> deleteSlackChannelConfigurationAsync(DeleteSlackChannelConfigurationRequest request) {
        return this.deleteSlackChannelConfigurationAsync(request, null);
    }

    @Override
    public Future<DeleteSlackChannelConfigurationResult> deleteSlackChannelConfigurationAsync(DeleteSlackChannelConfigurationRequest request, final AsyncHandler<DeleteSlackChannelConfigurationRequest, DeleteSlackChannelConfigurationResult> asyncHandler) {
        final DeleteSlackChannelConfigurationRequest finalRequest = (DeleteSlackChannelConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteSlackChannelConfigurationResult>(){

            @Override
            public DeleteSlackChannelConfigurationResult call() throws Exception {
                DeleteSlackChannelConfigurationResult result = null;
                try {
                    result = AWSSupportAppAsyncClient.this.executeDeleteSlackChannelConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteSlackWorkspaceConfigurationResult> deleteSlackWorkspaceConfigurationAsync(DeleteSlackWorkspaceConfigurationRequest request) {
        return this.deleteSlackWorkspaceConfigurationAsync(request, null);
    }

    @Override
    public Future<DeleteSlackWorkspaceConfigurationResult> deleteSlackWorkspaceConfigurationAsync(DeleteSlackWorkspaceConfigurationRequest request, final AsyncHandler<DeleteSlackWorkspaceConfigurationRequest, DeleteSlackWorkspaceConfigurationResult> asyncHandler) {
        final DeleteSlackWorkspaceConfigurationRequest finalRequest = (DeleteSlackWorkspaceConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteSlackWorkspaceConfigurationResult>(){

            @Override
            public DeleteSlackWorkspaceConfigurationResult call() throws Exception {
                DeleteSlackWorkspaceConfigurationResult result = null;
                try {
                    result = AWSSupportAppAsyncClient.this.executeDeleteSlackWorkspaceConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetAccountAliasResult> getAccountAliasAsync(GetAccountAliasRequest request) {
        return this.getAccountAliasAsync(request, null);
    }

    @Override
    public Future<GetAccountAliasResult> getAccountAliasAsync(GetAccountAliasRequest request, final AsyncHandler<GetAccountAliasRequest, GetAccountAliasResult> asyncHandler) {
        final GetAccountAliasRequest finalRequest = (GetAccountAliasRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetAccountAliasResult>(){

            @Override
            public GetAccountAliasResult call() throws Exception {
                GetAccountAliasResult result = null;
                try {
                    result = AWSSupportAppAsyncClient.this.executeGetAccountAlias(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListSlackChannelConfigurationsResult> listSlackChannelConfigurationsAsync(ListSlackChannelConfigurationsRequest request) {
        return this.listSlackChannelConfigurationsAsync(request, null);
    }

    @Override
    public Future<ListSlackChannelConfigurationsResult> listSlackChannelConfigurationsAsync(ListSlackChannelConfigurationsRequest request, final AsyncHandler<ListSlackChannelConfigurationsRequest, ListSlackChannelConfigurationsResult> asyncHandler) {
        final ListSlackChannelConfigurationsRequest finalRequest = (ListSlackChannelConfigurationsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListSlackChannelConfigurationsResult>(){

            @Override
            public ListSlackChannelConfigurationsResult call() throws Exception {
                ListSlackChannelConfigurationsResult result = null;
                try {
                    result = AWSSupportAppAsyncClient.this.executeListSlackChannelConfigurations(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListSlackWorkspaceConfigurationsResult> listSlackWorkspaceConfigurationsAsync(ListSlackWorkspaceConfigurationsRequest request) {
        return this.listSlackWorkspaceConfigurationsAsync(request, null);
    }

    @Override
    public Future<ListSlackWorkspaceConfigurationsResult> listSlackWorkspaceConfigurationsAsync(ListSlackWorkspaceConfigurationsRequest request, final AsyncHandler<ListSlackWorkspaceConfigurationsRequest, ListSlackWorkspaceConfigurationsResult> asyncHandler) {
        final ListSlackWorkspaceConfigurationsRequest finalRequest = (ListSlackWorkspaceConfigurationsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListSlackWorkspaceConfigurationsResult>(){

            @Override
            public ListSlackWorkspaceConfigurationsResult call() throws Exception {
                ListSlackWorkspaceConfigurationsResult result = null;
                try {
                    result = AWSSupportAppAsyncClient.this.executeListSlackWorkspaceConfigurations(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutAccountAliasResult> putAccountAliasAsync(PutAccountAliasRequest request) {
        return this.putAccountAliasAsync(request, null);
    }

    @Override
    public Future<PutAccountAliasResult> putAccountAliasAsync(PutAccountAliasRequest request, final AsyncHandler<PutAccountAliasRequest, PutAccountAliasResult> asyncHandler) {
        final PutAccountAliasRequest finalRequest = (PutAccountAliasRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutAccountAliasResult>(){

            @Override
            public PutAccountAliasResult call() throws Exception {
                PutAccountAliasResult result = null;
                try {
                    result = AWSSupportAppAsyncClient.this.executePutAccountAlias(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RegisterSlackWorkspaceForOrganizationResult> registerSlackWorkspaceForOrganizationAsync(RegisterSlackWorkspaceForOrganizationRequest request) {
        return this.registerSlackWorkspaceForOrganizationAsync(request, null);
    }

    @Override
    public Future<RegisterSlackWorkspaceForOrganizationResult> registerSlackWorkspaceForOrganizationAsync(RegisterSlackWorkspaceForOrganizationRequest request, final AsyncHandler<RegisterSlackWorkspaceForOrganizationRequest, RegisterSlackWorkspaceForOrganizationResult> asyncHandler) {
        final RegisterSlackWorkspaceForOrganizationRequest finalRequest = (RegisterSlackWorkspaceForOrganizationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RegisterSlackWorkspaceForOrganizationResult>(){

            @Override
            public RegisterSlackWorkspaceForOrganizationResult call() throws Exception {
                RegisterSlackWorkspaceForOrganizationResult result = null;
                try {
                    result = AWSSupportAppAsyncClient.this.executeRegisterSlackWorkspaceForOrganization(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateSlackChannelConfigurationResult> updateSlackChannelConfigurationAsync(UpdateSlackChannelConfigurationRequest request) {
        return this.updateSlackChannelConfigurationAsync(request, null);
    }

    @Override
    public Future<UpdateSlackChannelConfigurationResult> updateSlackChannelConfigurationAsync(UpdateSlackChannelConfigurationRequest request, final AsyncHandler<UpdateSlackChannelConfigurationRequest, UpdateSlackChannelConfigurationResult> asyncHandler) {
        final UpdateSlackChannelConfigurationRequest finalRequest = (UpdateSlackChannelConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateSlackChannelConfigurationResult>(){

            @Override
            public UpdateSlackChannelConfigurationResult call() throws Exception {
                UpdateSlackChannelConfigurationResult result = null;
                try {
                    result = AWSSupportAppAsyncClient.this.executeUpdateSlackChannelConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

