/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.stepfunctions.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.stepfunctions.model.ActivityListItem;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListActivitiesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<ActivityListItem> activities;
    private String nextToken;

    public List<ActivityListItem> getActivities() {
        return this.activities;
    }

    public void setActivities(Collection<ActivityListItem> activities) {
        if (activities == null) {
            this.activities = null;
            return;
        }
        this.activities = new ArrayList<ActivityListItem>(activities);
    }

    public ListActivitiesResult withActivities(ActivityListItem ... activities) {
        if (this.activities == null) {
            this.setActivities(new ArrayList<ActivityListItem>(activities.length));
        }
        for (ActivityListItem ele : activities) {
            this.activities.add(ele);
        }
        return this;
    }

    public ListActivitiesResult withActivities(Collection<ActivityListItem> activities) {
        this.setActivities(activities);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListActivitiesResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getActivities() != null) {
            sb.append("Activities: ").append(this.getActivities()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListActivitiesResult)) {
            return false;
        }
        ListActivitiesResult other = (ListActivitiesResult)obj;
        if (other.getActivities() == null ^ this.getActivities() == null) {
            return false;
        }
        if (other.getActivities() != null && !other.getActivities().equals(this.getActivities())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getActivities() == null ? 0 : this.getActivities().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListActivitiesResult clone() {
        try {
            return (ListActivitiesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

