/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ssmincidents.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.ssmincidents.model.EventReference;
import com.amazonaws.services.ssmincidents.model.transform.TimelineEventMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class TimelineEvent
implements Serializable,
Cloneable,
StructuredPojo {
    private String eventData;
    private String eventId;
    private List<EventReference> eventReferences;
    private Date eventTime;
    private String eventType;
    private Date eventUpdatedTime;
    private String incidentRecordArn;

    public void setEventData(String eventData) {
        this.eventData = eventData;
    }

    public String getEventData() {
        return this.eventData;
    }

    public TimelineEvent withEventData(String eventData) {
        this.setEventData(eventData);
        return this;
    }

    public void setEventId(String eventId) {
        this.eventId = eventId;
    }

    public String getEventId() {
        return this.eventId;
    }

    public TimelineEvent withEventId(String eventId) {
        this.setEventId(eventId);
        return this;
    }

    public List<EventReference> getEventReferences() {
        return this.eventReferences;
    }

    public void setEventReferences(Collection<EventReference> eventReferences) {
        if (eventReferences == null) {
            this.eventReferences = null;
            return;
        }
        this.eventReferences = new ArrayList<EventReference>(eventReferences);
    }

    public TimelineEvent withEventReferences(EventReference ... eventReferences) {
        if (this.eventReferences == null) {
            this.setEventReferences(new ArrayList<EventReference>(eventReferences.length));
        }
        for (EventReference ele : eventReferences) {
            this.eventReferences.add(ele);
        }
        return this;
    }

    public TimelineEvent withEventReferences(Collection<EventReference> eventReferences) {
        this.setEventReferences(eventReferences);
        return this;
    }

    public void setEventTime(Date eventTime) {
        this.eventTime = eventTime;
    }

    public Date getEventTime() {
        return this.eventTime;
    }

    public TimelineEvent withEventTime(Date eventTime) {
        this.setEventTime(eventTime);
        return this;
    }

    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    public String getEventType() {
        return this.eventType;
    }

    public TimelineEvent withEventType(String eventType) {
        this.setEventType(eventType);
        return this;
    }

    public void setEventUpdatedTime(Date eventUpdatedTime) {
        this.eventUpdatedTime = eventUpdatedTime;
    }

    public Date getEventUpdatedTime() {
        return this.eventUpdatedTime;
    }

    public TimelineEvent withEventUpdatedTime(Date eventUpdatedTime) {
        this.setEventUpdatedTime(eventUpdatedTime);
        return this;
    }

    public void setIncidentRecordArn(String incidentRecordArn) {
        this.incidentRecordArn = incidentRecordArn;
    }

    public String getIncidentRecordArn() {
        return this.incidentRecordArn;
    }

    public TimelineEvent withIncidentRecordArn(String incidentRecordArn) {
        this.setIncidentRecordArn(incidentRecordArn);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEventData() != null) {
            sb.append("EventData: ").append(this.getEventData()).append(",");
        }
        if (this.getEventId() != null) {
            sb.append("EventId: ").append(this.getEventId()).append(",");
        }
        if (this.getEventReferences() != null) {
            sb.append("EventReferences: ").append(this.getEventReferences()).append(",");
        }
        if (this.getEventTime() != null) {
            sb.append("EventTime: ").append(this.getEventTime()).append(",");
        }
        if (this.getEventType() != null) {
            sb.append("EventType: ").append(this.getEventType()).append(",");
        }
        if (this.getEventUpdatedTime() != null) {
            sb.append("EventUpdatedTime: ").append(this.getEventUpdatedTime()).append(",");
        }
        if (this.getIncidentRecordArn() != null) {
            sb.append("IncidentRecordArn: ").append(this.getIncidentRecordArn());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimelineEvent)) {
            return false;
        }
        TimelineEvent other = (TimelineEvent)obj;
        if (other.getEventData() == null ^ this.getEventData() == null) {
            return false;
        }
        if (other.getEventData() != null && !other.getEventData().equals(this.getEventData())) {
            return false;
        }
        if (other.getEventId() == null ^ this.getEventId() == null) {
            return false;
        }
        if (other.getEventId() != null && !other.getEventId().equals(this.getEventId())) {
            return false;
        }
        if (other.getEventReferences() == null ^ this.getEventReferences() == null) {
            return false;
        }
        if (other.getEventReferences() != null && !other.getEventReferences().equals(this.getEventReferences())) {
            return false;
        }
        if (other.getEventTime() == null ^ this.getEventTime() == null) {
            return false;
        }
        if (other.getEventTime() != null && !other.getEventTime().equals(this.getEventTime())) {
            return false;
        }
        if (other.getEventType() == null ^ this.getEventType() == null) {
            return false;
        }
        if (other.getEventType() != null && !other.getEventType().equals(this.getEventType())) {
            return false;
        }
        if (other.getEventUpdatedTime() == null ^ this.getEventUpdatedTime() == null) {
            return false;
        }
        if (other.getEventUpdatedTime() != null && !other.getEventUpdatedTime().equals(this.getEventUpdatedTime())) {
            return false;
        }
        if (other.getIncidentRecordArn() == null ^ this.getIncidentRecordArn() == null) {
            return false;
        }
        return other.getIncidentRecordArn() == null || other.getIncidentRecordArn().equals(this.getIncidentRecordArn());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEventData() == null ? 0 : this.getEventData().hashCode());
        hashCode = 31 * hashCode + (this.getEventId() == null ? 0 : this.getEventId().hashCode());
        hashCode = 31 * hashCode + (this.getEventReferences() == null ? 0 : this.getEventReferences().hashCode());
        hashCode = 31 * hashCode + (this.getEventTime() == null ? 0 : this.getEventTime().hashCode());
        hashCode = 31 * hashCode + (this.getEventType() == null ? 0 : this.getEventType().hashCode());
        hashCode = 31 * hashCode + (this.getEventUpdatedTime() == null ? 0 : this.getEventUpdatedTime().hashCode());
        hashCode = 31 * hashCode + (this.getIncidentRecordArn() == null ? 0 : this.getIncidentRecordArn().hashCode());
        return hashCode;
    }

    public TimelineEvent clone() {
        try {
            return (TimelineEvent)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TimelineEventMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

