/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ssmincidents.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.ssmincidents.model.SsmTargetAccount;
import com.amazonaws.services.ssmincidents.model.transform.SsmAutomationMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SsmAutomation
implements Serializable,
Cloneable,
StructuredPojo {
    private String documentName;
    private String documentVersion;
    private Map<String, List<String>> parameters;
    private String roleArn;
    private String targetAccount;

    public void setDocumentName(String documentName) {
        this.documentName = documentName;
    }

    public String getDocumentName() {
        return this.documentName;
    }

    public SsmAutomation withDocumentName(String documentName) {
        this.setDocumentName(documentName);
        return this;
    }

    public void setDocumentVersion(String documentVersion) {
        this.documentVersion = documentVersion;
    }

    public String getDocumentVersion() {
        return this.documentVersion;
    }

    public SsmAutomation withDocumentVersion(String documentVersion) {
        this.setDocumentVersion(documentVersion);
        return this;
    }

    public Map<String, List<String>> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, List<String>> parameters) {
        this.parameters = parameters;
    }

    public SsmAutomation withParameters(Map<String, List<String>> parameters) {
        this.setParameters(parameters);
        return this;
    }

    public SsmAutomation addParametersEntry(String key, List<String> value) {
        if (null == this.parameters) {
            this.parameters = new HashMap<String, List<String>>();
        }
        if (this.parameters.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.parameters.put(key, value);
        return this;
    }

    public SsmAutomation clearParametersEntries() {
        this.parameters = null;
        return this;
    }

    public void setRoleArn(String roleArn) {
        this.roleArn = roleArn;
    }

    public String getRoleArn() {
        return this.roleArn;
    }

    public SsmAutomation withRoleArn(String roleArn) {
        this.setRoleArn(roleArn);
        return this;
    }

    public void setTargetAccount(String targetAccount) {
        this.targetAccount = targetAccount;
    }

    public String getTargetAccount() {
        return this.targetAccount;
    }

    public SsmAutomation withTargetAccount(String targetAccount) {
        this.setTargetAccount(targetAccount);
        return this;
    }

    public SsmAutomation withTargetAccount(SsmTargetAccount targetAccount) {
        this.targetAccount = targetAccount.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDocumentName() != null) {
            sb.append("DocumentName: ").append(this.getDocumentName()).append(",");
        }
        if (this.getDocumentVersion() != null) {
            sb.append("DocumentVersion: ").append(this.getDocumentVersion()).append(",");
        }
        if (this.getParameters() != null) {
            sb.append("Parameters: ").append(this.getParameters()).append(",");
        }
        if (this.getRoleArn() != null) {
            sb.append("RoleArn: ").append(this.getRoleArn()).append(",");
        }
        if (this.getTargetAccount() != null) {
            sb.append("TargetAccount: ").append(this.getTargetAccount());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SsmAutomation)) {
            return false;
        }
        SsmAutomation other = (SsmAutomation)obj;
        if (other.getDocumentName() == null ^ this.getDocumentName() == null) {
            return false;
        }
        if (other.getDocumentName() != null && !other.getDocumentName().equals(this.getDocumentName())) {
            return false;
        }
        if (other.getDocumentVersion() == null ^ this.getDocumentVersion() == null) {
            return false;
        }
        if (other.getDocumentVersion() != null && !other.getDocumentVersion().equals(this.getDocumentVersion())) {
            return false;
        }
        if (other.getParameters() == null ^ this.getParameters() == null) {
            return false;
        }
        if (other.getParameters() != null && !other.getParameters().equals(this.getParameters())) {
            return false;
        }
        if (other.getRoleArn() == null ^ this.getRoleArn() == null) {
            return false;
        }
        if (other.getRoleArn() != null && !other.getRoleArn().equals(this.getRoleArn())) {
            return false;
        }
        if (other.getTargetAccount() == null ^ this.getTargetAccount() == null) {
            return false;
        }
        return other.getTargetAccount() == null || other.getTargetAccount().equals(this.getTargetAccount());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDocumentName() == null ? 0 : this.getDocumentName().hashCode());
        hashCode = 31 * hashCode + (this.getDocumentVersion() == null ? 0 : this.getDocumentVersion().hashCode());
        hashCode = 31 * hashCode + (this.getParameters() == null ? 0 : this.getParameters().hashCode());
        hashCode = 31 * hashCode + (this.getRoleArn() == null ? 0 : this.getRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getTargetAccount() == null ? 0 : this.getTargetAccount().hashCode());
        return hashCode;
    }

    public SsmAutomation clone() {
        try {
            return (SsmAutomation)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SsmAutomationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

