/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.shield.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.shield.model.AttackProperty;
import java.util.List;

@SdkInternalApi
public class AttackPropertyMarshaller {
    private static final MarshallingInfo<String> ATTACKLAYER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AttackLayer").build();
    private static final MarshallingInfo<String> ATTACKPROPERTYIDENTIFIER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AttackPropertyIdentifier").build();
    private static final MarshallingInfo<List> TOPCONTRIBUTORS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TopContributors").build();
    private static final MarshallingInfo<String> UNIT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Unit").build();
    private static final MarshallingInfo<Long> TOTAL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Total").build();
    private static final AttackPropertyMarshaller instance = new AttackPropertyMarshaller();

    public static AttackPropertyMarshaller getInstance() {
        return instance;
    }

    public void marshall(AttackProperty attackProperty, ProtocolMarshaller protocolMarshaller) {
        if (attackProperty == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)attackProperty.getAttackLayer(), ATTACKLAYER_BINDING);
            protocolMarshaller.marshall((Object)attackProperty.getAttackPropertyIdentifier(), ATTACKPROPERTYIDENTIFIER_BINDING);
            protocolMarshaller.marshall(attackProperty.getTopContributors(), TOPCONTRIBUTORS_BINDING);
            protocolMarshaller.marshall((Object)attackProperty.getUnit(), UNIT_BINDING);
            protocolMarshaller.marshall((Object)attackProperty.getTotal(), TOTAL_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

