/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleemailv2.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.simpleemailv2.model.Body;
import com.amazonaws.services.simpleemailv2.model.Content;
import com.amazonaws.services.simpleemailv2.model.MessageHeader;
import com.amazonaws.services.simpleemailv2.model.transform.MessageMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Message
implements Serializable,
Cloneable,
StructuredPojo {
    private Content subject;
    private Body body;
    private List<MessageHeader> headers;

    public void setSubject(Content subject) {
        this.subject = subject;
    }

    public Content getSubject() {
        return this.subject;
    }

    public Message withSubject(Content subject) {
        this.setSubject(subject);
        return this;
    }

    public void setBody(Body body) {
        this.body = body;
    }

    public Body getBody() {
        return this.body;
    }

    public Message withBody(Body body) {
        this.setBody(body);
        return this;
    }

    public List<MessageHeader> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Collection<MessageHeader> headers) {
        if (headers == null) {
            this.headers = null;
            return;
        }
        this.headers = new ArrayList<MessageHeader>(headers);
    }

    public Message withHeaders(MessageHeader ... headers) {
        if (this.headers == null) {
            this.setHeaders(new ArrayList<MessageHeader>(headers.length));
        }
        for (MessageHeader ele : headers) {
            this.headers.add(ele);
        }
        return this;
    }

    public Message withHeaders(Collection<MessageHeader> headers) {
        this.setHeaders(headers);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSubject() != null) {
            sb.append("Subject: ").append(this.getSubject()).append(",");
        }
        if (this.getBody() != null) {
            sb.append("Body: ").append(this.getBody()).append(",");
        }
        if (this.getHeaders() != null) {
            sb.append("Headers: ").append(this.getHeaders());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Message)) {
            return false;
        }
        Message other = (Message)obj;
        if (other.getSubject() == null ^ this.getSubject() == null) {
            return false;
        }
        if (other.getSubject() != null && !other.getSubject().equals(this.getSubject())) {
            return false;
        }
        if (other.getBody() == null ^ this.getBody() == null) {
            return false;
        }
        if (other.getBody() != null && !other.getBody().equals(this.getBody())) {
            return false;
        }
        if (other.getHeaders() == null ^ this.getHeaders() == null) {
            return false;
        }
        return other.getHeaders() == null || other.getHeaders().equals(this.getHeaders());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSubject() == null ? 0 : this.getSubject().hashCode());
        hashCode = 31 * hashCode + (this.getBody() == null ? 0 : this.getBody().hashCode());
        hashCode = 31 * hashCode + (this.getHeaders() == null ? 0 : this.getHeaders().hashCode());
        return hashCode;
    }

    public Message clone() {
        try {
            return (Message)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MessageMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

