/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleemailv2.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.simpleemailv2.model.TopicPreference;
import com.amazonaws.services.simpleemailv2.model.transform.ContactMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class Contact
implements Serializable,
Cloneable,
StructuredPojo {
    private String emailAddress;
    private List<TopicPreference> topicPreferences;
    private List<TopicPreference> topicDefaultPreferences;
    private Boolean unsubscribeAll;
    private Date lastUpdatedTimestamp;

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public Contact withEmailAddress(String emailAddress) {
        this.setEmailAddress(emailAddress);
        return this;
    }

    public List<TopicPreference> getTopicPreferences() {
        return this.topicPreferences;
    }

    public void setTopicPreferences(Collection<TopicPreference> topicPreferences) {
        if (topicPreferences == null) {
            this.topicPreferences = null;
            return;
        }
        this.topicPreferences = new ArrayList<TopicPreference>(topicPreferences);
    }

    public Contact withTopicPreferences(TopicPreference ... topicPreferences) {
        if (this.topicPreferences == null) {
            this.setTopicPreferences(new ArrayList<TopicPreference>(topicPreferences.length));
        }
        for (TopicPreference ele : topicPreferences) {
            this.topicPreferences.add(ele);
        }
        return this;
    }

    public Contact withTopicPreferences(Collection<TopicPreference> topicPreferences) {
        this.setTopicPreferences(topicPreferences);
        return this;
    }

    public List<TopicPreference> getTopicDefaultPreferences() {
        return this.topicDefaultPreferences;
    }

    public void setTopicDefaultPreferences(Collection<TopicPreference> topicDefaultPreferences) {
        if (topicDefaultPreferences == null) {
            this.topicDefaultPreferences = null;
            return;
        }
        this.topicDefaultPreferences = new ArrayList<TopicPreference>(topicDefaultPreferences);
    }

    public Contact withTopicDefaultPreferences(TopicPreference ... topicDefaultPreferences) {
        if (this.topicDefaultPreferences == null) {
            this.setTopicDefaultPreferences(new ArrayList<TopicPreference>(topicDefaultPreferences.length));
        }
        for (TopicPreference ele : topicDefaultPreferences) {
            this.topicDefaultPreferences.add(ele);
        }
        return this;
    }

    public Contact withTopicDefaultPreferences(Collection<TopicPreference> topicDefaultPreferences) {
        this.setTopicDefaultPreferences(topicDefaultPreferences);
        return this;
    }

    public void setUnsubscribeAll(Boolean unsubscribeAll) {
        this.unsubscribeAll = unsubscribeAll;
    }

    public Boolean getUnsubscribeAll() {
        return this.unsubscribeAll;
    }

    public Contact withUnsubscribeAll(Boolean unsubscribeAll) {
        this.setUnsubscribeAll(unsubscribeAll);
        return this;
    }

    public Boolean isUnsubscribeAll() {
        return this.unsubscribeAll;
    }

    public void setLastUpdatedTimestamp(Date lastUpdatedTimestamp) {
        this.lastUpdatedTimestamp = lastUpdatedTimestamp;
    }

    public Date getLastUpdatedTimestamp() {
        return this.lastUpdatedTimestamp;
    }

    public Contact withLastUpdatedTimestamp(Date lastUpdatedTimestamp) {
        this.setLastUpdatedTimestamp(lastUpdatedTimestamp);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEmailAddress() != null) {
            sb.append("EmailAddress: ").append(this.getEmailAddress()).append(",");
        }
        if (this.getTopicPreferences() != null) {
            sb.append("TopicPreferences: ").append(this.getTopicPreferences()).append(",");
        }
        if (this.getTopicDefaultPreferences() != null) {
            sb.append("TopicDefaultPreferences: ").append(this.getTopicDefaultPreferences()).append(",");
        }
        if (this.getUnsubscribeAll() != null) {
            sb.append("UnsubscribeAll: ").append(this.getUnsubscribeAll()).append(",");
        }
        if (this.getLastUpdatedTimestamp() != null) {
            sb.append("LastUpdatedTimestamp: ").append(this.getLastUpdatedTimestamp());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Contact)) {
            return false;
        }
        Contact other = (Contact)obj;
        if (other.getEmailAddress() == null ^ this.getEmailAddress() == null) {
            return false;
        }
        if (other.getEmailAddress() != null && !other.getEmailAddress().equals(this.getEmailAddress())) {
            return false;
        }
        if (other.getTopicPreferences() == null ^ this.getTopicPreferences() == null) {
            return false;
        }
        if (other.getTopicPreferences() != null && !other.getTopicPreferences().equals(this.getTopicPreferences())) {
            return false;
        }
        if (other.getTopicDefaultPreferences() == null ^ this.getTopicDefaultPreferences() == null) {
            return false;
        }
        if (other.getTopicDefaultPreferences() != null && !other.getTopicDefaultPreferences().equals(this.getTopicDefaultPreferences())) {
            return false;
        }
        if (other.getUnsubscribeAll() == null ^ this.getUnsubscribeAll() == null) {
            return false;
        }
        if (other.getUnsubscribeAll() != null && !other.getUnsubscribeAll().equals(this.getUnsubscribeAll())) {
            return false;
        }
        if (other.getLastUpdatedTimestamp() == null ^ this.getLastUpdatedTimestamp() == null) {
            return false;
        }
        return other.getLastUpdatedTimestamp() == null || other.getLastUpdatedTimestamp().equals(this.getLastUpdatedTimestamp());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEmailAddress() == null ? 0 : this.getEmailAddress().hashCode());
        hashCode = 31 * hashCode + (this.getTopicPreferences() == null ? 0 : this.getTopicPreferences().hashCode());
        hashCode = 31 * hashCode + (this.getTopicDefaultPreferences() == null ? 0 : this.getTopicDefaultPreferences().hashCode());
        hashCode = 31 * hashCode + (this.getUnsubscribeAll() == null ? 0 : this.getUnsubscribeAll().hashCode());
        hashCode = 31 * hashCode + (this.getLastUpdatedTimestamp() == null ? 0 : this.getLastUpdatedTimestamp().hashCode());
        return hashCode;
    }

    public Contact clone() {
        try {
            return (Contact)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ContactMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

