/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleemail.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.simpleemail.model.DescribeConfigurationSetRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeConfigurationSetRequestMarshaller
implements Marshaller<Request<DescribeConfigurationSetRequest>, DescribeConfigurationSetRequest> {
    public Request<DescribeConfigurationSetRequest> marshall(DescribeConfigurationSetRequest describeConfigurationSetRequest) {
        SdkInternalList configurationSetAttributeNamesList;
        if (describeConfigurationSetRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeConfigurationSetRequest, "AmazonSimpleEmailService");
        request.addParameter("Action", "DescribeConfigurationSet");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeConfigurationSetRequest.getConfigurationSetName() != null) {
            request.addParameter("ConfigurationSetName", StringUtils.fromString((String)describeConfigurationSetRequest.getConfigurationSetName()));
        }
        if (!(configurationSetAttributeNamesList = (SdkInternalList)describeConfigurationSetRequest.getConfigurationSetAttributeNames()).isEmpty() || !configurationSetAttributeNamesList.isAutoConstruct()) {
            int configurationSetAttributeNamesListIndex = 1;
            for (String configurationSetAttributeNamesListValue : configurationSetAttributeNamesList) {
                if (configurationSetAttributeNamesListValue != null) {
                    request.addParameter("ConfigurationSetAttributeNames.member." + configurationSetAttributeNamesListIndex, StringUtils.fromString((String)configurationSetAttributeNamesListValue));
                }
                ++configurationSetAttributeNamesListIndex;
            }
        }
        return request;
    }
}

