/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.servicediscovery;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.servicediscovery.AWSServiceDiscoveryAsync;
import com.amazonaws.services.servicediscovery.AWSServiceDiscoveryAsyncClientBuilder;
import com.amazonaws.services.servicediscovery.AWSServiceDiscoveryClient;
import com.amazonaws.services.servicediscovery.model.CreateHttpNamespaceRequest;
import com.amazonaws.services.servicediscovery.model.CreateHttpNamespaceResult;
import com.amazonaws.services.servicediscovery.model.CreatePrivateDnsNamespaceRequest;
import com.amazonaws.services.servicediscovery.model.CreatePrivateDnsNamespaceResult;
import com.amazonaws.services.servicediscovery.model.CreatePublicDnsNamespaceRequest;
import com.amazonaws.services.servicediscovery.model.CreatePublicDnsNamespaceResult;
import com.amazonaws.services.servicediscovery.model.CreateServiceRequest;
import com.amazonaws.services.servicediscovery.model.CreateServiceResult;
import com.amazonaws.services.servicediscovery.model.DeleteNamespaceRequest;
import com.amazonaws.services.servicediscovery.model.DeleteNamespaceResult;
import com.amazonaws.services.servicediscovery.model.DeleteServiceRequest;
import com.amazonaws.services.servicediscovery.model.DeleteServiceResult;
import com.amazonaws.services.servicediscovery.model.DeregisterInstanceRequest;
import com.amazonaws.services.servicediscovery.model.DeregisterInstanceResult;
import com.amazonaws.services.servicediscovery.model.DiscoverInstancesRequest;
import com.amazonaws.services.servicediscovery.model.DiscoverInstancesResult;
import com.amazonaws.services.servicediscovery.model.GetInstanceRequest;
import com.amazonaws.services.servicediscovery.model.GetInstanceResult;
import com.amazonaws.services.servicediscovery.model.GetInstancesHealthStatusRequest;
import com.amazonaws.services.servicediscovery.model.GetInstancesHealthStatusResult;
import com.amazonaws.services.servicediscovery.model.GetNamespaceRequest;
import com.amazonaws.services.servicediscovery.model.GetNamespaceResult;
import com.amazonaws.services.servicediscovery.model.GetOperationRequest;
import com.amazonaws.services.servicediscovery.model.GetOperationResult;
import com.amazonaws.services.servicediscovery.model.GetServiceRequest;
import com.amazonaws.services.servicediscovery.model.GetServiceResult;
import com.amazonaws.services.servicediscovery.model.ListInstancesRequest;
import com.amazonaws.services.servicediscovery.model.ListInstancesResult;
import com.amazonaws.services.servicediscovery.model.ListNamespacesRequest;
import com.amazonaws.services.servicediscovery.model.ListNamespacesResult;
import com.amazonaws.services.servicediscovery.model.ListOperationsRequest;
import com.amazonaws.services.servicediscovery.model.ListOperationsResult;
import com.amazonaws.services.servicediscovery.model.ListServicesRequest;
import com.amazonaws.services.servicediscovery.model.ListServicesResult;
import com.amazonaws.services.servicediscovery.model.RegisterInstanceRequest;
import com.amazonaws.services.servicediscovery.model.RegisterInstanceResult;
import com.amazonaws.services.servicediscovery.model.UpdateInstanceCustomHealthStatusRequest;
import com.amazonaws.services.servicediscovery.model.UpdateInstanceCustomHealthStatusResult;
import com.amazonaws.services.servicediscovery.model.UpdateServiceRequest;
import com.amazonaws.services.servicediscovery.model.UpdateServiceResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSServiceDiscoveryAsyncClient
extends AWSServiceDiscoveryClient
implements AWSServiceDiscoveryAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSServiceDiscoveryAsyncClientBuilder asyncBuilder() {
        return AWSServiceDiscoveryAsyncClientBuilder.standard();
    }

    AWSServiceDiscoveryAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super((AwsSyncClientParams)asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateHttpNamespaceResult> createHttpNamespaceAsync(CreateHttpNamespaceRequest request) {
        return this.createHttpNamespaceAsync(request, null);
    }

    @Override
    public Future<CreateHttpNamespaceResult> createHttpNamespaceAsync(CreateHttpNamespaceRequest request, final AsyncHandler<CreateHttpNamespaceRequest, CreateHttpNamespaceResult> asyncHandler) {
        final CreateHttpNamespaceRequest finalRequest = (CreateHttpNamespaceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateHttpNamespaceResult>(){

            @Override
            public CreateHttpNamespaceResult call() throws Exception {
                CreateHttpNamespaceResult result = null;
                try {
                    result = AWSServiceDiscoveryAsyncClient.this.executeCreateHttpNamespace(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreatePrivateDnsNamespaceResult> createPrivateDnsNamespaceAsync(CreatePrivateDnsNamespaceRequest request) {
        return this.createPrivateDnsNamespaceAsync(request, null);
    }

    @Override
    public Future<CreatePrivateDnsNamespaceResult> createPrivateDnsNamespaceAsync(CreatePrivateDnsNamespaceRequest request, final AsyncHandler<CreatePrivateDnsNamespaceRequest, CreatePrivateDnsNamespaceResult> asyncHandler) {
        final CreatePrivateDnsNamespaceRequest finalRequest = (CreatePrivateDnsNamespaceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreatePrivateDnsNamespaceResult>(){

            @Override
            public CreatePrivateDnsNamespaceResult call() throws Exception {
                CreatePrivateDnsNamespaceResult result = null;
                try {
                    result = AWSServiceDiscoveryAsyncClient.this.executeCreatePrivateDnsNamespace(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreatePublicDnsNamespaceResult> createPublicDnsNamespaceAsync(CreatePublicDnsNamespaceRequest request) {
        return this.createPublicDnsNamespaceAsync(request, null);
    }

    @Override
    public Future<CreatePublicDnsNamespaceResult> createPublicDnsNamespaceAsync(CreatePublicDnsNamespaceRequest request, final AsyncHandler<CreatePublicDnsNamespaceRequest, CreatePublicDnsNamespaceResult> asyncHandler) {
        final CreatePublicDnsNamespaceRequest finalRequest = (CreatePublicDnsNamespaceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreatePublicDnsNamespaceResult>(){

            @Override
            public CreatePublicDnsNamespaceResult call() throws Exception {
                CreatePublicDnsNamespaceResult result = null;
                try {
                    result = AWSServiceDiscoveryAsyncClient.this.executeCreatePublicDnsNamespace(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateServiceResult> createServiceAsync(CreateServiceRequest request) {
        return this.createServiceAsync(request, null);
    }

    @Override
    public Future<CreateServiceResult> createServiceAsync(CreateServiceRequest request, final AsyncHandler<CreateServiceRequest, CreateServiceResult> asyncHandler) {
        final CreateServiceRequest finalRequest = (CreateServiceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateServiceResult>(){

            @Override
            public CreateServiceResult call() throws Exception {
                CreateServiceResult result = null;
                try {
                    result = AWSServiceDiscoveryAsyncClient.this.executeCreateService(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteNamespaceResult> deleteNamespaceAsync(DeleteNamespaceRequest request) {
        return this.deleteNamespaceAsync(request, null);
    }

    @Override
    public Future<DeleteNamespaceResult> deleteNamespaceAsync(DeleteNamespaceRequest request, final AsyncHandler<DeleteNamespaceRequest, DeleteNamespaceResult> asyncHandler) {
        final DeleteNamespaceRequest finalRequest = (DeleteNamespaceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteNamespaceResult>(){

            @Override
            public DeleteNamespaceResult call() throws Exception {
                DeleteNamespaceResult result = null;
                try {
                    result = AWSServiceDiscoveryAsyncClient.this.executeDeleteNamespace(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteServiceResult> deleteServiceAsync(DeleteServiceRequest request) {
        return this.deleteServiceAsync(request, null);
    }

    @Override
    public Future<DeleteServiceResult> deleteServiceAsync(DeleteServiceRequest request, final AsyncHandler<DeleteServiceRequest, DeleteServiceResult> asyncHandler) {
        final DeleteServiceRequest finalRequest = (DeleteServiceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteServiceResult>(){

            @Override
            public DeleteServiceResult call() throws Exception {
                DeleteServiceResult result = null;
                try {
                    result = AWSServiceDiscoveryAsyncClient.this.executeDeleteService(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeregisterInstanceResult> deregisterInstanceAsync(DeregisterInstanceRequest request) {
        return this.deregisterInstanceAsync(request, null);
    }

    @Override
    public Future<DeregisterInstanceResult> deregisterInstanceAsync(DeregisterInstanceRequest request, final AsyncHandler<DeregisterInstanceRequest, DeregisterInstanceResult> asyncHandler) {
        final DeregisterInstanceRequest finalRequest = (DeregisterInstanceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeregisterInstanceResult>(){

            @Override
            public DeregisterInstanceResult call() throws Exception {
                DeregisterInstanceResult result = null;
                try {
                    result = AWSServiceDiscoveryAsyncClient.this.executeDeregisterInstance(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DiscoverInstancesResult> discoverInstancesAsync(DiscoverInstancesRequest request) {
        return this.discoverInstancesAsync(request, null);
    }

    @Override
    public Future<DiscoverInstancesResult> discoverInstancesAsync(DiscoverInstancesRequest request, final AsyncHandler<DiscoverInstancesRequest, DiscoverInstancesResult> asyncHandler) {
        final DiscoverInstancesRequest finalRequest = (DiscoverInstancesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DiscoverInstancesResult>(){

            @Override
            public DiscoverInstancesResult call() throws Exception {
                DiscoverInstancesResult result = null;
                try {
                    result = AWSServiceDiscoveryAsyncClient.this.executeDiscoverInstances(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetInstanceResult> getInstanceAsync(GetInstanceRequest request) {
        return this.getInstanceAsync(request, null);
    }

    @Override
    public Future<GetInstanceResult> getInstanceAsync(GetInstanceRequest request, final AsyncHandler<GetInstanceRequest, GetInstanceResult> asyncHandler) {
        final GetInstanceRequest finalRequest = (GetInstanceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetInstanceResult>(){

            @Override
            public GetInstanceResult call() throws Exception {
                GetInstanceResult result = null;
                try {
                    result = AWSServiceDiscoveryAsyncClient.this.executeGetInstance(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetInstancesHealthStatusResult> getInstancesHealthStatusAsync(GetInstancesHealthStatusRequest request) {
        return this.getInstancesHealthStatusAsync(request, null);
    }

    @Override
    public Future<GetInstancesHealthStatusResult> getInstancesHealthStatusAsync(GetInstancesHealthStatusRequest request, final AsyncHandler<GetInstancesHealthStatusRequest, GetInstancesHealthStatusResult> asyncHandler) {
        final GetInstancesHealthStatusRequest finalRequest = (GetInstancesHealthStatusRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetInstancesHealthStatusResult>(){

            @Override
            public GetInstancesHealthStatusResult call() throws Exception {
                GetInstancesHealthStatusResult result = null;
                try {
                    result = AWSServiceDiscoveryAsyncClient.this.executeGetInstancesHealthStatus(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetNamespaceResult> getNamespaceAsync(GetNamespaceRequest request) {
        return this.getNamespaceAsync(request, null);
    }

    @Override
    public Future<GetNamespaceResult> getNamespaceAsync(GetNamespaceRequest request, final AsyncHandler<GetNamespaceRequest, GetNamespaceResult> asyncHandler) {
        final GetNamespaceRequest finalRequest = (GetNamespaceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetNamespaceResult>(){

            @Override
            public GetNamespaceResult call() throws Exception {
                GetNamespaceResult result = null;
                try {
                    result = AWSServiceDiscoveryAsyncClient.this.executeGetNamespace(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetOperationResult> getOperationAsync(GetOperationRequest request) {
        return this.getOperationAsync(request, null);
    }

    @Override
    public Future<GetOperationResult> getOperationAsync(GetOperationRequest request, final AsyncHandler<GetOperationRequest, GetOperationResult> asyncHandler) {
        final GetOperationRequest finalRequest = (GetOperationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetOperationResult>(){

            @Override
            public GetOperationResult call() throws Exception {
                GetOperationResult result = null;
                try {
                    result = AWSServiceDiscoveryAsyncClient.this.executeGetOperation(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetServiceResult> getServiceAsync(GetServiceRequest request) {
        return this.getServiceAsync(request, null);
    }

    @Override
    public Future<GetServiceResult> getServiceAsync(GetServiceRequest request, final AsyncHandler<GetServiceRequest, GetServiceResult> asyncHandler) {
        final GetServiceRequest finalRequest = (GetServiceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetServiceResult>(){

            @Override
            public GetServiceResult call() throws Exception {
                GetServiceResult result = null;
                try {
                    result = AWSServiceDiscoveryAsyncClient.this.executeGetService(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListInstancesResult> listInstancesAsync(ListInstancesRequest request) {
        return this.listInstancesAsync(request, null);
    }

    @Override
    public Future<ListInstancesResult> listInstancesAsync(ListInstancesRequest request, final AsyncHandler<ListInstancesRequest, ListInstancesResult> asyncHandler) {
        final ListInstancesRequest finalRequest = (ListInstancesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListInstancesResult>(){

            @Override
            public ListInstancesResult call() throws Exception {
                ListInstancesResult result = null;
                try {
                    result = AWSServiceDiscoveryAsyncClient.this.executeListInstances(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListNamespacesResult> listNamespacesAsync(ListNamespacesRequest request) {
        return this.listNamespacesAsync(request, null);
    }

    @Override
    public Future<ListNamespacesResult> listNamespacesAsync(ListNamespacesRequest request, final AsyncHandler<ListNamespacesRequest, ListNamespacesResult> asyncHandler) {
        final ListNamespacesRequest finalRequest = (ListNamespacesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListNamespacesResult>(){

            @Override
            public ListNamespacesResult call() throws Exception {
                ListNamespacesResult result = null;
                try {
                    result = AWSServiceDiscoveryAsyncClient.this.executeListNamespaces(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListOperationsResult> listOperationsAsync(ListOperationsRequest request) {
        return this.listOperationsAsync(request, null);
    }

    @Override
    public Future<ListOperationsResult> listOperationsAsync(ListOperationsRequest request, final AsyncHandler<ListOperationsRequest, ListOperationsResult> asyncHandler) {
        final ListOperationsRequest finalRequest = (ListOperationsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListOperationsResult>(){

            @Override
            public ListOperationsResult call() throws Exception {
                ListOperationsResult result = null;
                try {
                    result = AWSServiceDiscoveryAsyncClient.this.executeListOperations(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListServicesResult> listServicesAsync(ListServicesRequest request) {
        return this.listServicesAsync(request, null);
    }

    @Override
    public Future<ListServicesResult> listServicesAsync(ListServicesRequest request, final AsyncHandler<ListServicesRequest, ListServicesResult> asyncHandler) {
        final ListServicesRequest finalRequest = (ListServicesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListServicesResult>(){

            @Override
            public ListServicesResult call() throws Exception {
                ListServicesResult result = null;
                try {
                    result = AWSServiceDiscoveryAsyncClient.this.executeListServices(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RegisterInstanceResult> registerInstanceAsync(RegisterInstanceRequest request) {
        return this.registerInstanceAsync(request, null);
    }

    @Override
    public Future<RegisterInstanceResult> registerInstanceAsync(RegisterInstanceRequest request, final AsyncHandler<RegisterInstanceRequest, RegisterInstanceResult> asyncHandler) {
        final RegisterInstanceRequest finalRequest = (RegisterInstanceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RegisterInstanceResult>(){

            @Override
            public RegisterInstanceResult call() throws Exception {
                RegisterInstanceResult result = null;
                try {
                    result = AWSServiceDiscoveryAsyncClient.this.executeRegisterInstance(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateInstanceCustomHealthStatusResult> updateInstanceCustomHealthStatusAsync(UpdateInstanceCustomHealthStatusRequest request) {
        return this.updateInstanceCustomHealthStatusAsync(request, null);
    }

    @Override
    public Future<UpdateInstanceCustomHealthStatusResult> updateInstanceCustomHealthStatusAsync(UpdateInstanceCustomHealthStatusRequest request, final AsyncHandler<UpdateInstanceCustomHealthStatusRequest, UpdateInstanceCustomHealthStatusResult> asyncHandler) {
        final UpdateInstanceCustomHealthStatusRequest finalRequest = (UpdateInstanceCustomHealthStatusRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateInstanceCustomHealthStatusResult>(){

            @Override
            public UpdateInstanceCustomHealthStatusResult call() throws Exception {
                UpdateInstanceCustomHealthStatusResult result = null;
                try {
                    result = AWSServiceDiscoveryAsyncClient.this.executeUpdateInstanceCustomHealthStatus(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateServiceResult> updateServiceAsync(UpdateServiceRequest request) {
        return this.updateServiceAsync(request, null);
    }

    @Override
    public Future<UpdateServiceResult> updateServiceAsync(UpdateServiceRequest request, final AsyncHandler<UpdateServiceRequest, UpdateServiceResult> asyncHandler) {
        final UpdateServiceRequest finalRequest = (UpdateServiceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateServiceResult>(){

            @Override
            public UpdateServiceResult call() throws Exception {
                UpdateServiceResult result = null;
                try {
                    result = AWSServiceDiscoveryAsyncClient.this.executeUpdateService(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

