/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.securitylake.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.securitylake.model.AccessType;
import com.amazonaws.services.securitylake.model.AwsIdentity;
import com.amazonaws.services.securitylake.model.LogSourceResource;
import com.amazonaws.services.securitylake.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateSubscriberRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private List<String> accessTypes;
    private List<LogSourceResource> sources;
    private String subscriberDescription;
    private AwsIdentity subscriberIdentity;
    private String subscriberName;
    private List<Tag> tags;

    public List<String> getAccessTypes() {
        return this.accessTypes;
    }

    public void setAccessTypes(Collection<String> accessTypes) {
        if (accessTypes == null) {
            this.accessTypes = null;
            return;
        }
        this.accessTypes = new ArrayList<String>(accessTypes);
    }

    public CreateSubscriberRequest withAccessTypes(String ... accessTypes) {
        if (this.accessTypes == null) {
            this.setAccessTypes(new ArrayList<String>(accessTypes.length));
        }
        for (String ele : accessTypes) {
            this.accessTypes.add(ele);
        }
        return this;
    }

    public CreateSubscriberRequest withAccessTypes(Collection<String> accessTypes) {
        this.setAccessTypes(accessTypes);
        return this;
    }

    public CreateSubscriberRequest withAccessTypes(AccessType ... accessTypes) {
        ArrayList<String> accessTypesCopy = new ArrayList<String>(accessTypes.length);
        for (AccessType value : accessTypes) {
            accessTypesCopy.add(value.toString());
        }
        if (this.getAccessTypes() == null) {
            this.setAccessTypes(accessTypesCopy);
        } else {
            this.getAccessTypes().addAll(accessTypesCopy);
        }
        return this;
    }

    public List<LogSourceResource> getSources() {
        return this.sources;
    }

    public void setSources(Collection<LogSourceResource> sources) {
        if (sources == null) {
            this.sources = null;
            return;
        }
        this.sources = new ArrayList<LogSourceResource>(sources);
    }

    public CreateSubscriberRequest withSources(LogSourceResource ... sources) {
        if (this.sources == null) {
            this.setSources(new ArrayList<LogSourceResource>(sources.length));
        }
        for (LogSourceResource ele : sources) {
            this.sources.add(ele);
        }
        return this;
    }

    public CreateSubscriberRequest withSources(Collection<LogSourceResource> sources) {
        this.setSources(sources);
        return this;
    }

    public void setSubscriberDescription(String subscriberDescription) {
        this.subscriberDescription = subscriberDescription;
    }

    public String getSubscriberDescription() {
        return this.subscriberDescription;
    }

    public CreateSubscriberRequest withSubscriberDescription(String subscriberDescription) {
        this.setSubscriberDescription(subscriberDescription);
        return this;
    }

    public void setSubscriberIdentity(AwsIdentity subscriberIdentity) {
        this.subscriberIdentity = subscriberIdentity;
    }

    public AwsIdentity getSubscriberIdentity() {
        return this.subscriberIdentity;
    }

    public CreateSubscriberRequest withSubscriberIdentity(AwsIdentity subscriberIdentity) {
        this.setSubscriberIdentity(subscriberIdentity);
        return this;
    }

    public void setSubscriberName(String subscriberName) {
        this.subscriberName = subscriberName;
    }

    public String getSubscriberName() {
        return this.subscriberName;
    }

    public CreateSubscriberRequest withSubscriberName(String subscriberName) {
        this.setSubscriberName(subscriberName);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreateSubscriberRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateSubscriberRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAccessTypes() != null) {
            sb.append("AccessTypes: ").append(this.getAccessTypes()).append(",");
        }
        if (this.getSources() != null) {
            sb.append("Sources: ").append(this.getSources()).append(",");
        }
        if (this.getSubscriberDescription() != null) {
            sb.append("SubscriberDescription: ").append(this.getSubscriberDescription()).append(",");
        }
        if (this.getSubscriberIdentity() != null) {
            sb.append("SubscriberIdentity: ").append(this.getSubscriberIdentity()).append(",");
        }
        if (this.getSubscriberName() != null) {
            sb.append("SubscriberName: ").append(this.getSubscriberName()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSubscriberRequest)) {
            return false;
        }
        CreateSubscriberRequest other = (CreateSubscriberRequest)obj;
        if (other.getAccessTypes() == null ^ this.getAccessTypes() == null) {
            return false;
        }
        if (other.getAccessTypes() != null && !other.getAccessTypes().equals(this.getAccessTypes())) {
            return false;
        }
        if (other.getSources() == null ^ this.getSources() == null) {
            return false;
        }
        if (other.getSources() != null && !other.getSources().equals(this.getSources())) {
            return false;
        }
        if (other.getSubscriberDescription() == null ^ this.getSubscriberDescription() == null) {
            return false;
        }
        if (other.getSubscriberDescription() != null && !other.getSubscriberDescription().equals(this.getSubscriberDescription())) {
            return false;
        }
        if (other.getSubscriberIdentity() == null ^ this.getSubscriberIdentity() == null) {
            return false;
        }
        if (other.getSubscriberIdentity() != null && !other.getSubscriberIdentity().equals(this.getSubscriberIdentity())) {
            return false;
        }
        if (other.getSubscriberName() == null ^ this.getSubscriberName() == null) {
            return false;
        }
        if (other.getSubscriberName() != null && !other.getSubscriberName().equals(this.getSubscriberName())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAccessTypes() == null ? 0 : this.getAccessTypes().hashCode());
        hashCode = 31 * hashCode + (this.getSources() == null ? 0 : this.getSources().hashCode());
        hashCode = 31 * hashCode + (this.getSubscriberDescription() == null ? 0 : this.getSubscriberDescription().hashCode());
        hashCode = 31 * hashCode + (this.getSubscriberIdentity() == null ? 0 : this.getSubscriberIdentity().hashCode());
        hashCode = 31 * hashCode + (this.getSubscriberName() == null ? 0 : this.getSubscriberName().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreateSubscriberRequest clone() {
        return (CreateSubscriberRequest)super.clone();
    }
}

