/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.securitylake.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.securitylake.model.AwsLogSourceName;
import com.amazonaws.services.securitylake.model.transform.AwsLogSourceConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AwsLogSourceConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> accounts;
    private List<String> regions;
    private String sourceName;
    private String sourceVersion;

    public List<String> getAccounts() {
        return this.accounts;
    }

    public void setAccounts(Collection<String> accounts) {
        if (accounts == null) {
            this.accounts = null;
            return;
        }
        this.accounts = new ArrayList<String>(accounts);
    }

    public AwsLogSourceConfiguration withAccounts(String ... accounts) {
        if (this.accounts == null) {
            this.setAccounts(new ArrayList<String>(accounts.length));
        }
        for (String ele : accounts) {
            this.accounts.add(ele);
        }
        return this;
    }

    public AwsLogSourceConfiguration withAccounts(Collection<String> accounts) {
        this.setAccounts(accounts);
        return this;
    }

    public List<String> getRegions() {
        return this.regions;
    }

    public void setRegions(Collection<String> regions) {
        if (regions == null) {
            this.regions = null;
            return;
        }
        this.regions = new ArrayList<String>(regions);
    }

    public AwsLogSourceConfiguration withRegions(String ... regions) {
        if (this.regions == null) {
            this.setRegions(new ArrayList<String>(regions.length));
        }
        for (String ele : regions) {
            this.regions.add(ele);
        }
        return this;
    }

    public AwsLogSourceConfiguration withRegions(Collection<String> regions) {
        this.setRegions(regions);
        return this;
    }

    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public AwsLogSourceConfiguration withSourceName(String sourceName) {
        this.setSourceName(sourceName);
        return this;
    }

    public AwsLogSourceConfiguration withSourceName(AwsLogSourceName sourceName) {
        this.sourceName = sourceName.toString();
        return this;
    }

    public void setSourceVersion(String sourceVersion) {
        this.sourceVersion = sourceVersion;
    }

    public String getSourceVersion() {
        return this.sourceVersion;
    }

    public AwsLogSourceConfiguration withSourceVersion(String sourceVersion) {
        this.setSourceVersion(sourceVersion);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAccounts() != null) {
            sb.append("Accounts: ").append(this.getAccounts()).append(",");
        }
        if (this.getRegions() != null) {
            sb.append("Regions: ").append(this.getRegions()).append(",");
        }
        if (this.getSourceName() != null) {
            sb.append("SourceName: ").append(this.getSourceName()).append(",");
        }
        if (this.getSourceVersion() != null) {
            sb.append("SourceVersion: ").append(this.getSourceVersion());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsLogSourceConfiguration)) {
            return false;
        }
        AwsLogSourceConfiguration other = (AwsLogSourceConfiguration)obj;
        if (other.getAccounts() == null ^ this.getAccounts() == null) {
            return false;
        }
        if (other.getAccounts() != null && !other.getAccounts().equals(this.getAccounts())) {
            return false;
        }
        if (other.getRegions() == null ^ this.getRegions() == null) {
            return false;
        }
        if (other.getRegions() != null && !other.getRegions().equals(this.getRegions())) {
            return false;
        }
        if (other.getSourceName() == null ^ this.getSourceName() == null) {
            return false;
        }
        if (other.getSourceName() != null && !other.getSourceName().equals(this.getSourceName())) {
            return false;
        }
        if (other.getSourceVersion() == null ^ this.getSourceVersion() == null) {
            return false;
        }
        return other.getSourceVersion() == null || other.getSourceVersion().equals(this.getSourceVersion());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAccounts() == null ? 0 : this.getAccounts().hashCode());
        hashCode = 31 * hashCode + (this.getRegions() == null ? 0 : this.getRegions().hashCode());
        hashCode = 31 * hashCode + (this.getSourceName() == null ? 0 : this.getSourceName().hashCode());
        hashCode = 31 * hashCode + (this.getSourceVersion() == null ? 0 : this.getSourceVersion().hashCode());
        return hashCode;
    }

    public AwsLogSourceConfiguration clone() {
        try {
            return (AwsLogSourceConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AwsLogSourceConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

