/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.securityhub.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Provides information about the settings that Amazon EFS uses to create the root directory when a client connects to
 * an access point.
 * </p>
 * 
 * @see <a
 *      href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/AwsEfsAccessPointRootDirectoryCreationInfoDetails"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AwsEfsAccessPointRootDirectoryCreationInfoDetails implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * Specifies the POSIX group ID to apply to the root directory.
     * </p>
     */
    private String ownerGid;
    /**
     * <p>
     * Specifies the POSIX user ID to apply to the root directory.
     * </p>
     */
    private String ownerUid;
    /**
     * <p>
     * Specifies the POSIX permissions to apply to the root directory, in the format of an octal number representing the
     * file's mode bits.
     * </p>
     */
    private String permissions;

    /**
     * <p>
     * Specifies the POSIX group ID to apply to the root directory.
     * </p>
     * 
     * @param ownerGid
     *        Specifies the POSIX group ID to apply to the root directory.
     */

    public void setOwnerGid(String ownerGid) {
        this.ownerGid = ownerGid;
    }

    /**
     * <p>
     * Specifies the POSIX group ID to apply to the root directory.
     * </p>
     * 
     * @return Specifies the POSIX group ID to apply to the root directory.
     */

    public String getOwnerGid() {
        return this.ownerGid;
    }

    /**
     * <p>
     * Specifies the POSIX group ID to apply to the root directory.
     * </p>
     * 
     * @param ownerGid
     *        Specifies the POSIX group ID to apply to the root directory.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsEfsAccessPointRootDirectoryCreationInfoDetails withOwnerGid(String ownerGid) {
        setOwnerGid(ownerGid);
        return this;
    }

    /**
     * <p>
     * Specifies the POSIX user ID to apply to the root directory.
     * </p>
     * 
     * @param ownerUid
     *        Specifies the POSIX user ID to apply to the root directory.
     */

    public void setOwnerUid(String ownerUid) {
        this.ownerUid = ownerUid;
    }

    /**
     * <p>
     * Specifies the POSIX user ID to apply to the root directory.
     * </p>
     * 
     * @return Specifies the POSIX user ID to apply to the root directory.
     */

    public String getOwnerUid() {
        return this.ownerUid;
    }

    /**
     * <p>
     * Specifies the POSIX user ID to apply to the root directory.
     * </p>
     * 
     * @param ownerUid
     *        Specifies the POSIX user ID to apply to the root directory.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsEfsAccessPointRootDirectoryCreationInfoDetails withOwnerUid(String ownerUid) {
        setOwnerUid(ownerUid);
        return this;
    }

    /**
     * <p>
     * Specifies the POSIX permissions to apply to the root directory, in the format of an octal number representing the
     * file's mode bits.
     * </p>
     * 
     * @param permissions
     *        Specifies the POSIX permissions to apply to the root directory, in the format of an octal number
     *        representing the file's mode bits.
     */

    public void setPermissions(String permissions) {
        this.permissions = permissions;
    }

    /**
     * <p>
     * Specifies the POSIX permissions to apply to the root directory, in the format of an octal number representing the
     * file's mode bits.
     * </p>
     * 
     * @return Specifies the POSIX permissions to apply to the root directory, in the format of an octal number
     *         representing the file's mode bits.
     */

    public String getPermissions() {
        return this.permissions;
    }

    /**
     * <p>
     * Specifies the POSIX permissions to apply to the root directory, in the format of an octal number representing the
     * file's mode bits.
     * </p>
     * 
     * @param permissions
     *        Specifies the POSIX permissions to apply to the root directory, in the format of an octal number
     *        representing the file's mode bits.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsEfsAccessPointRootDirectoryCreationInfoDetails withPermissions(String permissions) {
        setPermissions(permissions);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getOwnerGid() != null)
            sb.append("OwnerGid: ").append(getOwnerGid()).append(",");
        if (getOwnerUid() != null)
            sb.append("OwnerUid: ").append(getOwnerUid()).append(",");
        if (getPermissions() != null)
            sb.append("Permissions: ").append(getPermissions());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof AwsEfsAccessPointRootDirectoryCreationInfoDetails == false)
            return false;
        AwsEfsAccessPointRootDirectoryCreationInfoDetails other = (AwsEfsAccessPointRootDirectoryCreationInfoDetails) obj;
        if (other.getOwnerGid() == null ^ this.getOwnerGid() == null)
            return false;
        if (other.getOwnerGid() != null && other.getOwnerGid().equals(this.getOwnerGid()) == false)
            return false;
        if (other.getOwnerUid() == null ^ this.getOwnerUid() == null)
            return false;
        if (other.getOwnerUid() != null && other.getOwnerUid().equals(this.getOwnerUid()) == false)
            return false;
        if (other.getPermissions() == null ^ this.getPermissions() == null)
            return false;
        if (other.getPermissions() != null && other.getPermissions().equals(this.getPermissions()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getOwnerGid() == null) ? 0 : getOwnerGid().hashCode());
        hashCode = prime * hashCode + ((getOwnerUid() == null) ? 0 : getOwnerUid().hashCode());
        hashCode = prime * hashCode + ((getPermissions() == null) ? 0 : getPermissions().hashCode());
        return hashCode;
    }

    @Override
    public AwsEfsAccessPointRootDirectoryCreationInfoDetails clone() {
        try {
            return (AwsEfsAccessPointRootDirectoryCreationInfoDetails) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.securityhub.model.transform.AwsEfsAccessPointRootDirectoryCreationInfoDetailsMarshaller.getInstance().marshall(this,
                protocolMarshaller);
    }
}
