/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.securityhub.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.securityhub.model.SensitiveDataDetections;
import com.amazonaws.services.securityhub.model.transform.SensitiveDataResultMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SensitiveDataResult
implements Serializable,
Cloneable,
StructuredPojo {
    private String category;
    private List<SensitiveDataDetections> detections;
    private Long totalCount;

    public void setCategory(String category) {
        this.category = category;
    }

    public String getCategory() {
        return this.category;
    }

    public SensitiveDataResult withCategory(String category) {
        this.setCategory(category);
        return this;
    }

    public List<SensitiveDataDetections> getDetections() {
        return this.detections;
    }

    public void setDetections(Collection<SensitiveDataDetections> detections) {
        if (detections == null) {
            this.detections = null;
            return;
        }
        this.detections = new ArrayList<SensitiveDataDetections>(detections);
    }

    public SensitiveDataResult withDetections(SensitiveDataDetections ... detections) {
        if (this.detections == null) {
            this.setDetections(new ArrayList<SensitiveDataDetections>(detections.length));
        }
        for (SensitiveDataDetections ele : detections) {
            this.detections.add(ele);
        }
        return this;
    }

    public SensitiveDataResult withDetections(Collection<SensitiveDataDetections> detections) {
        this.setDetections(detections);
        return this;
    }

    public void setTotalCount(Long totalCount) {
        this.totalCount = totalCount;
    }

    public Long getTotalCount() {
        return this.totalCount;
    }

    public SensitiveDataResult withTotalCount(Long totalCount) {
        this.setTotalCount(totalCount);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCategory() != null) {
            sb.append("Category: ").append(this.getCategory()).append(",");
        }
        if (this.getDetections() != null) {
            sb.append("Detections: ").append(this.getDetections()).append(",");
        }
        if (this.getTotalCount() != null) {
            sb.append("TotalCount: ").append(this.getTotalCount());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SensitiveDataResult)) {
            return false;
        }
        SensitiveDataResult other = (SensitiveDataResult)obj;
        if (other.getCategory() == null ^ this.getCategory() == null) {
            return false;
        }
        if (other.getCategory() != null && !other.getCategory().equals(this.getCategory())) {
            return false;
        }
        if (other.getDetections() == null ^ this.getDetections() == null) {
            return false;
        }
        if (other.getDetections() != null && !other.getDetections().equals(this.getDetections())) {
            return false;
        }
        if (other.getTotalCount() == null ^ this.getTotalCount() == null) {
            return false;
        }
        return other.getTotalCount() == null || other.getTotalCount().equals(this.getTotalCount());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCategory() == null ? 0 : this.getCategory().hashCode());
        hashCode = 31 * hashCode + (this.getDetections() == null ? 0 : this.getDetections().hashCode());
        hashCode = 31 * hashCode + (this.getTotalCount() == null ? 0 : this.getTotalCount().hashCode());
        return hashCode;
    }

    public SensitiveDataResult clone() {
        try {
            return (SensitiveDataResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SensitiveDataResultMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

