/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.secretsmanager.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.secretsmanager.model.ReplicaRegionType;
import com.amazonaws.services.secretsmanager.model.Tag;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateSecretRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String name;
    private String clientRequestToken;
    private String description;
    private String kmsKeyId;
    private ByteBuffer secretBinary;
    private String secretString;
    private List<Tag> tags;
    private List<ReplicaRegionType> addReplicaRegions;
    private Boolean forceOverwriteReplicaSecret;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public CreateSecretRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public void setClientRequestToken(String clientRequestToken) {
        this.clientRequestToken = clientRequestToken;
    }

    public String getClientRequestToken() {
        return this.clientRequestToken;
    }

    public CreateSecretRequest withClientRequestToken(String clientRequestToken) {
        this.setClientRequestToken(clientRequestToken);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public CreateSecretRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setKmsKeyId(String kmsKeyId) {
        this.kmsKeyId = kmsKeyId;
    }

    public String getKmsKeyId() {
        return this.kmsKeyId;
    }

    public CreateSecretRequest withKmsKeyId(String kmsKeyId) {
        this.setKmsKeyId(kmsKeyId);
        return this;
    }

    public void setSecretBinary(ByteBuffer secretBinary) {
        this.secretBinary = secretBinary;
    }

    public ByteBuffer getSecretBinary() {
        return this.secretBinary;
    }

    public CreateSecretRequest withSecretBinary(ByteBuffer secretBinary) {
        this.setSecretBinary(secretBinary);
        return this;
    }

    public void setSecretString(String secretString) {
        this.secretString = secretString;
    }

    public String getSecretString() {
        return this.secretString;
    }

    public CreateSecretRequest withSecretString(String secretString) {
        this.setSecretString(secretString);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreateSecretRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateSecretRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public List<ReplicaRegionType> getAddReplicaRegions() {
        return this.addReplicaRegions;
    }

    public void setAddReplicaRegions(Collection<ReplicaRegionType> addReplicaRegions) {
        if (addReplicaRegions == null) {
            this.addReplicaRegions = null;
            return;
        }
        this.addReplicaRegions = new ArrayList<ReplicaRegionType>(addReplicaRegions);
    }

    public CreateSecretRequest withAddReplicaRegions(ReplicaRegionType ... addReplicaRegions) {
        if (this.addReplicaRegions == null) {
            this.setAddReplicaRegions(new ArrayList<ReplicaRegionType>(addReplicaRegions.length));
        }
        for (ReplicaRegionType ele : addReplicaRegions) {
            this.addReplicaRegions.add(ele);
        }
        return this;
    }

    public CreateSecretRequest withAddReplicaRegions(Collection<ReplicaRegionType> addReplicaRegions) {
        this.setAddReplicaRegions(addReplicaRegions);
        return this;
    }

    public void setForceOverwriteReplicaSecret(Boolean forceOverwriteReplicaSecret) {
        this.forceOverwriteReplicaSecret = forceOverwriteReplicaSecret;
    }

    public Boolean getForceOverwriteReplicaSecret() {
        return this.forceOverwriteReplicaSecret;
    }

    public CreateSecretRequest withForceOverwriteReplicaSecret(Boolean forceOverwriteReplicaSecret) {
        this.setForceOverwriteReplicaSecret(forceOverwriteReplicaSecret);
        return this;
    }

    public Boolean isForceOverwriteReplicaSecret() {
        return this.forceOverwriteReplicaSecret;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getClientRequestToken() != null) {
            sb.append("ClientRequestToken: ").append(this.getClientRequestToken()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getKmsKeyId() != null) {
            sb.append("KmsKeyId: ").append(this.getKmsKeyId()).append(",");
        }
        if (this.getSecretBinary() != null) {
            sb.append("SecretBinary: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getSecretString() != null) {
            sb.append("SecretString: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getAddReplicaRegions() != null) {
            sb.append("AddReplicaRegions: ").append(this.getAddReplicaRegions()).append(",");
        }
        if (this.getForceOverwriteReplicaSecret() != null) {
            sb.append("ForceOverwriteReplicaSecret: ").append(this.getForceOverwriteReplicaSecret());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSecretRequest)) {
            return false;
        }
        CreateSecretRequest other = (CreateSecretRequest)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getClientRequestToken() == null ^ this.getClientRequestToken() == null) {
            return false;
        }
        if (other.getClientRequestToken() != null && !other.getClientRequestToken().equals(this.getClientRequestToken())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getKmsKeyId() == null ^ this.getKmsKeyId() == null) {
            return false;
        }
        if (other.getKmsKeyId() != null && !other.getKmsKeyId().equals(this.getKmsKeyId())) {
            return false;
        }
        if (other.getSecretBinary() == null ^ this.getSecretBinary() == null) {
            return false;
        }
        if (other.getSecretBinary() != null && !other.getSecretBinary().equals(this.getSecretBinary())) {
            return false;
        }
        if (other.getSecretString() == null ^ this.getSecretString() == null) {
            return false;
        }
        if (other.getSecretString() != null && !other.getSecretString().equals(this.getSecretString())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getAddReplicaRegions() == null ^ this.getAddReplicaRegions() == null) {
            return false;
        }
        if (other.getAddReplicaRegions() != null && !other.getAddReplicaRegions().equals(this.getAddReplicaRegions())) {
            return false;
        }
        if (other.getForceOverwriteReplicaSecret() == null ^ this.getForceOverwriteReplicaSecret() == null) {
            return false;
        }
        return other.getForceOverwriteReplicaSecret() == null || other.getForceOverwriteReplicaSecret().equals(this.getForceOverwriteReplicaSecret());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getClientRequestToken() == null ? 0 : this.getClientRequestToken().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getKmsKeyId() == null ? 0 : this.getKmsKeyId().hashCode());
        hashCode = 31 * hashCode + (this.getSecretBinary() == null ? 0 : this.getSecretBinary().hashCode());
        hashCode = 31 * hashCode + (this.getSecretString() == null ? 0 : this.getSecretString().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getAddReplicaRegions() == null ? 0 : this.getAddReplicaRegions().hashCode());
        hashCode = 31 * hashCode + (this.getForceOverwriteReplicaSecret() == null ? 0 : this.getForceOverwriteReplicaSecret().hashCode());
        return hashCode;
    }

    public CreateSecretRequest clone() {
        return (CreateSecretRequest)super.clone();
    }
}

