/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemakergeospatial.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sagemakergeospatial.model.DataCollectionType;
import com.amazonaws.services.sagemakergeospatial.model.Filter;
import com.amazonaws.services.sagemakergeospatial.model.transform.RasterDataCollectionMetadataMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RasterDataCollectionMetadata
implements Serializable,
Cloneable,
StructuredPojo {
    private String arn;
    private String description;
    private String descriptionPageUrl;
    private String name;
    private List<Filter> supportedFilters;
    private Map<String, String> tags;
    private String type;

    public void setArn(String arn) {
        this.arn = arn;
    }

    public String getArn() {
        return this.arn;
    }

    public RasterDataCollectionMetadata withArn(String arn) {
        this.setArn(arn);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public RasterDataCollectionMetadata withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setDescriptionPageUrl(String descriptionPageUrl) {
        this.descriptionPageUrl = descriptionPageUrl;
    }

    public String getDescriptionPageUrl() {
        return this.descriptionPageUrl;
    }

    public RasterDataCollectionMetadata withDescriptionPageUrl(String descriptionPageUrl) {
        this.setDescriptionPageUrl(descriptionPageUrl);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public RasterDataCollectionMetadata withName(String name) {
        this.setName(name);
        return this;
    }

    public List<Filter> getSupportedFilters() {
        return this.supportedFilters;
    }

    public void setSupportedFilters(Collection<Filter> supportedFilters) {
        if (supportedFilters == null) {
            this.supportedFilters = null;
            return;
        }
        this.supportedFilters = new ArrayList<Filter>(supportedFilters);
    }

    public RasterDataCollectionMetadata withSupportedFilters(Filter ... supportedFilters) {
        if (this.supportedFilters == null) {
            this.setSupportedFilters(new ArrayList<Filter>(supportedFilters.length));
        }
        for (Filter ele : supportedFilters) {
            this.supportedFilters.add(ele);
        }
        return this;
    }

    public RasterDataCollectionMetadata withSupportedFilters(Collection<Filter> supportedFilters) {
        this.setSupportedFilters(supportedFilters);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public RasterDataCollectionMetadata withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public RasterDataCollectionMetadata addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public RasterDataCollectionMetadata clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public RasterDataCollectionMetadata withType(String type) {
        this.setType(type);
        return this;
    }

    public RasterDataCollectionMetadata withType(DataCollectionType type) {
        this.type = type.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getArn() != null) {
            sb.append("Arn: ").append(this.getArn()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getDescriptionPageUrl() != null) {
            sb.append("DescriptionPageUrl: ").append(this.getDescriptionPageUrl()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getSupportedFilters() != null) {
            sb.append("SupportedFilters: ").append(this.getSupportedFilters()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RasterDataCollectionMetadata)) {
            return false;
        }
        RasterDataCollectionMetadata other = (RasterDataCollectionMetadata)obj;
        if (other.getArn() == null ^ this.getArn() == null) {
            return false;
        }
        if (other.getArn() != null && !other.getArn().equals(this.getArn())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getDescriptionPageUrl() == null ^ this.getDescriptionPageUrl() == null) {
            return false;
        }
        if (other.getDescriptionPageUrl() != null && !other.getDescriptionPageUrl().equals(this.getDescriptionPageUrl())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getSupportedFilters() == null ^ this.getSupportedFilters() == null) {
            return false;
        }
        if (other.getSupportedFilters() != null && !other.getSupportedFilters().equals(this.getSupportedFilters())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        return other.getType() == null || other.getType().equals(this.getType());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getArn() == null ? 0 : this.getArn().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getDescriptionPageUrl() == null ? 0 : this.getDescriptionPageUrl().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getSupportedFilters() == null ? 0 : this.getSupportedFilters().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        return hashCode;
    }

    public RasterDataCollectionMetadata clone() {
        try {
            return (RasterDataCollectionMetadata)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RasterDataCollectionMetadataMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

