/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.sagemaker.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * The Amazon SageMaker Canvas application setting where you configure document querying.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/KendraSettings" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class KendraSettings implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * Describes whether the document querying feature is enabled or disabled in the Canvas application.
     * </p>
     */
    private String status;

    /**
     * <p>
     * Describes whether the document querying feature is enabled or disabled in the Canvas application.
     * </p>
     * 
     * @param status
     *        Describes whether the document querying feature is enabled or disabled in the Canvas application.
     * @see FeatureStatus
     */

    public void setStatus(String status) {
        this.status = status;
    }

    /**
     * <p>
     * Describes whether the document querying feature is enabled or disabled in the Canvas application.
     * </p>
     * 
     * @return Describes whether the document querying feature is enabled or disabled in the Canvas application.
     * @see FeatureStatus
     */

    public String getStatus() {
        return this.status;
    }

    /**
     * <p>
     * Describes whether the document querying feature is enabled or disabled in the Canvas application.
     * </p>
     * 
     * @param status
     *        Describes whether the document querying feature is enabled or disabled in the Canvas application.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see FeatureStatus
     */

    public KendraSettings withStatus(String status) {
        setStatus(status);
        return this;
    }

    /**
     * <p>
     * Describes whether the document querying feature is enabled or disabled in the Canvas application.
     * </p>
     * 
     * @param status
     *        Describes whether the document querying feature is enabled or disabled in the Canvas application.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see FeatureStatus
     */

    public KendraSettings withStatus(FeatureStatus status) {
        this.status = status.toString();
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getStatus() != null)
            sb.append("Status: ").append(getStatus());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof KendraSettings == false)
            return false;
        KendraSettings other = (KendraSettings) obj;
        if (other.getStatus() == null ^ this.getStatus() == null)
            return false;
        if (other.getStatus() != null && other.getStatus().equals(this.getStatus()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getStatus() == null) ? 0 : getStatus().hashCode());
        return hashCode;
    }

    @Override
    public KendraSettings clone() {
        try {
            return (KendraSettings) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.sagemaker.model.transform.KendraSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
