/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sagemaker.model.transform.ProfilerConfigMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class ProfilerConfig
implements Serializable,
Cloneable,
StructuredPojo {
    private String s3OutputPath;
    private Long profilingIntervalInMilliseconds;
    private Map<String, String> profilingParameters;

    public void setS3OutputPath(String s3OutputPath) {
        this.s3OutputPath = s3OutputPath;
    }

    public String getS3OutputPath() {
        return this.s3OutputPath;
    }

    public ProfilerConfig withS3OutputPath(String s3OutputPath) {
        this.setS3OutputPath(s3OutputPath);
        return this;
    }

    public void setProfilingIntervalInMilliseconds(Long profilingIntervalInMilliseconds) {
        this.profilingIntervalInMilliseconds = profilingIntervalInMilliseconds;
    }

    public Long getProfilingIntervalInMilliseconds() {
        return this.profilingIntervalInMilliseconds;
    }

    public ProfilerConfig withProfilingIntervalInMilliseconds(Long profilingIntervalInMilliseconds) {
        this.setProfilingIntervalInMilliseconds(profilingIntervalInMilliseconds);
        return this;
    }

    public Map<String, String> getProfilingParameters() {
        return this.profilingParameters;
    }

    public void setProfilingParameters(Map<String, String> profilingParameters) {
        this.profilingParameters = profilingParameters;
    }

    public ProfilerConfig withProfilingParameters(Map<String, String> profilingParameters) {
        this.setProfilingParameters(profilingParameters);
        return this;
    }

    public ProfilerConfig addProfilingParametersEntry(String key, String value) {
        if (null == this.profilingParameters) {
            this.profilingParameters = new HashMap<String, String>();
        }
        if (this.profilingParameters.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.profilingParameters.put(key, value);
        return this;
    }

    public ProfilerConfig clearProfilingParametersEntries() {
        this.profilingParameters = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getS3OutputPath() != null) {
            sb.append("S3OutputPath: ").append(this.getS3OutputPath()).append(",");
        }
        if (this.getProfilingIntervalInMilliseconds() != null) {
            sb.append("ProfilingIntervalInMilliseconds: ").append(this.getProfilingIntervalInMilliseconds()).append(",");
        }
        if (this.getProfilingParameters() != null) {
            sb.append("ProfilingParameters: ").append(this.getProfilingParameters());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProfilerConfig)) {
            return false;
        }
        ProfilerConfig other = (ProfilerConfig)obj;
        if (other.getS3OutputPath() == null ^ this.getS3OutputPath() == null) {
            return false;
        }
        if (other.getS3OutputPath() != null && !other.getS3OutputPath().equals(this.getS3OutputPath())) {
            return false;
        }
        if (other.getProfilingIntervalInMilliseconds() == null ^ this.getProfilingIntervalInMilliseconds() == null) {
            return false;
        }
        if (other.getProfilingIntervalInMilliseconds() != null && !other.getProfilingIntervalInMilliseconds().equals(this.getProfilingIntervalInMilliseconds())) {
            return false;
        }
        if (other.getProfilingParameters() == null ^ this.getProfilingParameters() == null) {
            return false;
        }
        return other.getProfilingParameters() == null || other.getProfilingParameters().equals(this.getProfilingParameters());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getS3OutputPath() == null ? 0 : this.getS3OutputPath().hashCode());
        hashCode = 31 * hashCode + (this.getProfilingIntervalInMilliseconds() == null ? 0 : this.getProfilingIntervalInMilliseconds().hashCode());
        hashCode = 31 * hashCode + (this.getProfilingParameters() == null ? 0 : this.getProfilingParameters().hashCode());
        return hashCode;
    }

    public ProfilerConfig clone() {
        try {
            return (ProfilerConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ProfilerConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

