/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.sagemaker.model.AuthMode;
import com.amazonaws.services.sagemaker.model.Tag;
import com.amazonaws.services.sagemaker.model.UserSettings;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateDomainRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String domainName;
    private String authMode;
    private UserSettings defaultUserSettings;
    private List<String> subnetIds;
    private String vpcId;
    private List<Tag> tags;
    private String homeEfsFileSystemKmsKeyId;

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public CreateDomainRequest withDomainName(String domainName) {
        this.setDomainName(domainName);
        return this;
    }

    public void setAuthMode(String authMode) {
        this.authMode = authMode;
    }

    public String getAuthMode() {
        return this.authMode;
    }

    public CreateDomainRequest withAuthMode(String authMode) {
        this.setAuthMode(authMode);
        return this;
    }

    public CreateDomainRequest withAuthMode(AuthMode authMode) {
        this.authMode = authMode.toString();
        return this;
    }

    public void setDefaultUserSettings(UserSettings defaultUserSettings) {
        this.defaultUserSettings = defaultUserSettings;
    }

    public UserSettings getDefaultUserSettings() {
        return this.defaultUserSettings;
    }

    public CreateDomainRequest withDefaultUserSettings(UserSettings defaultUserSettings) {
        this.setDefaultUserSettings(defaultUserSettings);
        return this;
    }

    public List<String> getSubnetIds() {
        return this.subnetIds;
    }

    public void setSubnetIds(Collection<String> subnetIds) {
        if (subnetIds == null) {
            this.subnetIds = null;
            return;
        }
        this.subnetIds = new ArrayList<String>(subnetIds);
    }

    public CreateDomainRequest withSubnetIds(String ... subnetIds) {
        if (this.subnetIds == null) {
            this.setSubnetIds(new ArrayList<String>(subnetIds.length));
        }
        for (String ele : subnetIds) {
            this.subnetIds.add(ele);
        }
        return this;
    }

    public CreateDomainRequest withSubnetIds(Collection<String> subnetIds) {
        this.setSubnetIds(subnetIds);
        return this;
    }

    public void setVpcId(String vpcId) {
        this.vpcId = vpcId;
    }

    public String getVpcId() {
        return this.vpcId;
    }

    public CreateDomainRequest withVpcId(String vpcId) {
        this.setVpcId(vpcId);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreateDomainRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateDomainRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public void setHomeEfsFileSystemKmsKeyId(String homeEfsFileSystemKmsKeyId) {
        this.homeEfsFileSystemKmsKeyId = homeEfsFileSystemKmsKeyId;
    }

    public String getHomeEfsFileSystemKmsKeyId() {
        return this.homeEfsFileSystemKmsKeyId;
    }

    public CreateDomainRequest withHomeEfsFileSystemKmsKeyId(String homeEfsFileSystemKmsKeyId) {
        this.setHomeEfsFileSystemKmsKeyId(homeEfsFileSystemKmsKeyId);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDomainName() != null) {
            sb.append("DomainName: ").append(this.getDomainName()).append(",");
        }
        if (this.getAuthMode() != null) {
            sb.append("AuthMode: ").append(this.getAuthMode()).append(",");
        }
        if (this.getDefaultUserSettings() != null) {
            sb.append("DefaultUserSettings: ").append(this.getDefaultUserSettings()).append(",");
        }
        if (this.getSubnetIds() != null) {
            sb.append("SubnetIds: ").append(this.getSubnetIds()).append(",");
        }
        if (this.getVpcId() != null) {
            sb.append("VpcId: ").append(this.getVpcId()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getHomeEfsFileSystemKmsKeyId() != null) {
            sb.append("HomeEfsFileSystemKmsKeyId: ").append(this.getHomeEfsFileSystemKmsKeyId());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDomainRequest)) {
            return false;
        }
        CreateDomainRequest other = (CreateDomainRequest)obj;
        if (other.getDomainName() == null ^ this.getDomainName() == null) {
            return false;
        }
        if (other.getDomainName() != null && !other.getDomainName().equals(this.getDomainName())) {
            return false;
        }
        if (other.getAuthMode() == null ^ this.getAuthMode() == null) {
            return false;
        }
        if (other.getAuthMode() != null && !other.getAuthMode().equals(this.getAuthMode())) {
            return false;
        }
        if (other.getDefaultUserSettings() == null ^ this.getDefaultUserSettings() == null) {
            return false;
        }
        if (other.getDefaultUserSettings() != null && !other.getDefaultUserSettings().equals(this.getDefaultUserSettings())) {
            return false;
        }
        if (other.getSubnetIds() == null ^ this.getSubnetIds() == null) {
            return false;
        }
        if (other.getSubnetIds() != null && !other.getSubnetIds().equals(this.getSubnetIds())) {
            return false;
        }
        if (other.getVpcId() == null ^ this.getVpcId() == null) {
            return false;
        }
        if (other.getVpcId() != null && !other.getVpcId().equals(this.getVpcId())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getHomeEfsFileSystemKmsKeyId() == null ^ this.getHomeEfsFileSystemKmsKeyId() == null) {
            return false;
        }
        return other.getHomeEfsFileSystemKmsKeyId() == null || other.getHomeEfsFileSystemKmsKeyId().equals(this.getHomeEfsFileSystemKmsKeyId());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDomainName() == null ? 0 : this.getDomainName().hashCode());
        hashCode = 31 * hashCode + (this.getAuthMode() == null ? 0 : this.getAuthMode().hashCode());
        hashCode = 31 * hashCode + (this.getDefaultUserSettings() == null ? 0 : this.getDefaultUserSettings().hashCode());
        hashCode = 31 * hashCode + (this.getSubnetIds() == null ? 0 : this.getSubnetIds().hashCode());
        hashCode = 31 * hashCode + (this.getVpcId() == null ? 0 : this.getVpcId().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getHomeEfsFileSystemKmsKeyId() == null ? 0 : this.getHomeEfsFileSystemKmsKeyId().hashCode());
        return hashCode;
    }

    public CreateDomainRequest clone() {
        return (CreateDomainRequest)super.clone();
    }
}

