/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.s3control.model.PutJobTaggingRequest;
import com.amazonaws.services.s3control.model.S3Tag;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.XMLWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;

public class PutJobTaggingRequestMarshaller
implements Marshaller<Request<PutJobTaggingRequest>, PutJobTaggingRequest> {
    public Request<PutJobTaggingRequest> marshall(PutJobTaggingRequest putJobTaggingRequest) {
        if (putJobTaggingRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)putJobTaggingRequest, "AWSS3Control");
        request.setHttpMethod(HttpMethodName.PUT);
        if (putJobTaggingRequest.getAccountId() != null) {
            request.addHeader("x-amz-account-id", StringUtils.fromString((String)putJobTaggingRequest.getAccountId()));
        }
        String uriResourcePath = "/v20180820/jobs/{id}/tagging";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "id", putJobTaggingRequest.getJobId());
        request.setResourcePath(uriResourcePath);
        try {
            List<S3Tag> putJobTaggingRequestTagsList;
            StringWriter stringWriter = new StringWriter();
            XMLWriter xmlWriter = new XMLWriter((Writer)stringWriter, "http://awss3control.amazonaws.com/doc/2018-08-20/");
            xmlWriter.startElement("PutJobTaggingRequest");
            if (putJobTaggingRequest != null && (putJobTaggingRequestTagsList = putJobTaggingRequest.getTags()) != null) {
                xmlWriter.startElement("Tags");
                for (S3Tag putJobTaggingRequestTagsListValue : putJobTaggingRequestTagsList) {
                    xmlWriter.startElement("member");
                    if (putJobTaggingRequestTagsListValue.getKey() != null) {
                        xmlWriter.startElement("Key").value(putJobTaggingRequestTagsListValue.getKey()).endElement();
                    }
                    if (putJobTaggingRequestTagsListValue.getValue() != null) {
                        xmlWriter.startElement("Value").value(putJobTaggingRequestTagsListValue.getValue()).endElement();
                    }
                    xmlWriter.endElement();
                }
                xmlWriter.endElement();
            }
            xmlWriter.endElement();
            request.setContent((InputStream)new StringInputStream(stringWriter.getBuffer().toString()));
            request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8).length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }
        return request;
    }
}

