/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.s3control.model.AwsLambdaTransformation;
import com.amazonaws.services.s3control.model.ObjectLambdaConfiguration;
import com.amazonaws.services.s3control.model.ObjectLambdaContentTransformation;
import com.amazonaws.services.s3control.model.ObjectLambdaTransformationConfiguration;
import com.amazonaws.services.s3control.model.PutAccessPointConfigurationForObjectLambdaRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.XMLWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;

public class PutAccessPointConfigurationForObjectLambdaRequestMarshaller
implements Marshaller<Request<PutAccessPointConfigurationForObjectLambdaRequest>, PutAccessPointConfigurationForObjectLambdaRequest> {
    public Request<PutAccessPointConfigurationForObjectLambdaRequest> marshall(PutAccessPointConfigurationForObjectLambdaRequest putAccessPointConfigurationForObjectLambdaRequest) {
        if (putAccessPointConfigurationForObjectLambdaRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)putAccessPointConfigurationForObjectLambdaRequest, "AWSS3Control");
        request.setHttpMethod(HttpMethodName.PUT);
        if (putAccessPointConfigurationForObjectLambdaRequest.getAccountId() != null) {
            request.addHeader("x-amz-account-id", StringUtils.fromString((String)putAccessPointConfigurationForObjectLambdaRequest.getAccountId()));
        }
        String uriResourcePath = "/v20180820/accesspointforobjectlambda/{name}/configuration";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "name", putAccessPointConfigurationForObjectLambdaRequest.getName());
        request.setResourcePath(uriResourcePath);
        try {
            ObjectLambdaConfiguration configuration;
            StringWriter stringWriter = new StringWriter();
            XMLWriter xmlWriter = new XMLWriter((Writer)stringWriter, "http://awss3control.amazonaws.com/doc/2018-08-20/");
            xmlWriter.startElement("PutAccessPointConfigurationForObjectLambdaRequest");
            if (putAccessPointConfigurationForObjectLambdaRequest != null && (configuration = putAccessPointConfigurationForObjectLambdaRequest.getConfiguration()) != null) {
                List<ObjectLambdaTransformationConfiguration> objectLambdaConfigurationTransformationConfigurationsList;
                List<String> objectLambdaConfigurationAllowedFeaturesList;
                xmlWriter.startElement("Configuration");
                if (configuration.getSupportingAccessPoint() != null) {
                    xmlWriter.startElement("SupportingAccessPoint").value(configuration.getSupportingAccessPoint()).endElement();
                }
                if (configuration.getCloudWatchMetricsEnabled() != null) {
                    xmlWriter.startElement("CloudWatchMetricsEnabled").value((Object)configuration.getCloudWatchMetricsEnabled()).endElement();
                }
                if ((objectLambdaConfigurationAllowedFeaturesList = configuration.getAllowedFeatures()) != null) {
                    xmlWriter.startElement("AllowedFeatures");
                    for (String objectLambdaConfigurationAllowedFeaturesListValue : objectLambdaConfigurationAllowedFeaturesList) {
                        xmlWriter.startElement("AllowedFeature");
                        xmlWriter.value(objectLambdaConfigurationAllowedFeaturesListValue);
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }
                if ((objectLambdaConfigurationTransformationConfigurationsList = configuration.getTransformationConfigurations()) != null) {
                    xmlWriter.startElement("TransformationConfigurations");
                    for (ObjectLambdaTransformationConfiguration objectLambdaConfigurationTransformationConfigurationsListValue : objectLambdaConfigurationTransformationConfigurationsList) {
                        ObjectLambdaContentTransformation contentTransformation;
                        xmlWriter.startElement("TransformationConfiguration");
                        List<String> objectLambdaTransformationConfigurationActionsList = objectLambdaConfigurationTransformationConfigurationsListValue.getActions();
                        if (objectLambdaTransformationConfigurationActionsList != null) {
                            xmlWriter.startElement("Actions");
                            for (String objectLambdaTransformationConfigurationActionsListValue : objectLambdaTransformationConfigurationActionsList) {
                                xmlWriter.startElement("Action");
                                xmlWriter.value(objectLambdaTransformationConfigurationActionsListValue);
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        if ((contentTransformation = objectLambdaConfigurationTransformationConfigurationsListValue.getContentTransformation()) != null) {
                            xmlWriter.startElement("ContentTransformation");
                            AwsLambdaTransformation awsLambda = contentTransformation.getAwsLambda();
                            if (awsLambda != null) {
                                xmlWriter.startElement("AwsLambda");
                                if (awsLambda.getFunctionArn() != null) {
                                    xmlWriter.startElement("FunctionArn").value(awsLambda.getFunctionArn()).endElement();
                                }
                                if (awsLambda.getFunctionPayload() != null) {
                                    xmlWriter.startElement("FunctionPayload").value(awsLambda.getFunctionPayload()).endElement();
                                }
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }
                xmlWriter.endElement();
            }
            xmlWriter.endElement();
            request.setContent((InputStream)new StringInputStream(stringWriter.getBuffer().toString()));
            request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8).length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }
        return request;
    }
}

