/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.model.transform;

import com.amazonaws.services.s3control.model.Metrics;
import com.amazonaws.services.s3control.model.transform.ReplicationTimeValueStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class MetricsStaxUnmarshaller
implements Unmarshaller<Metrics, StaxUnmarshallerContext> {
    private static MetricsStaxUnmarshaller instance;

    public Metrics unmarshall(StaxUnmarshallerContext context) throws Exception {
        Metrics metrics = new Metrics();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return metrics;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Status", targetDepth)) {
                    metrics.setStatus(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("EventThreshold", targetDepth)) continue;
                metrics.setEventThreshold(ReplicationTimeValueStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return metrics;
    }

    public static MetricsStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new MetricsStaxUnmarshaller();
        }
        return instance;
    }
}

