/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.s3control.model.GetBucketPolicyRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import com.amazonaws.util.StringUtils;

public class GetBucketPolicyRequestMarshaller
implements Marshaller<Request<GetBucketPolicyRequest>, GetBucketPolicyRequest> {
    public Request<GetBucketPolicyRequest> marshall(GetBucketPolicyRequest getBucketPolicyRequest) {
        if (getBucketPolicyRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getBucketPolicyRequest, "AWSS3Control");
        request.setHttpMethod(HttpMethodName.GET);
        if (getBucketPolicyRequest.getAccountId() != null) {
            request.addHeader("x-amz-account-id", StringUtils.fromString((String)getBucketPolicyRequest.getAccountId()));
        }
        String uriResourcePath = "/v20180820/bucket/{name}/policy";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "name", getBucketPolicyRequest.getBucket());
        request.setResourcePath(uriResourcePath);
        return request;
    }
}

