/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.model.transform;

import com.amazonaws.services.s3control.model.AsyncOperation;
import com.amazonaws.services.s3control.model.transform.AsyncRequestParametersStaxUnmarshaller;
import com.amazonaws.services.s3control.model.transform.AsyncResponseDetailsStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class AsyncOperationStaxUnmarshaller
implements Unmarshaller<AsyncOperation, StaxUnmarshallerContext> {
    private static AsyncOperationStaxUnmarshaller instance;

    public AsyncOperation unmarshall(StaxUnmarshallerContext context) throws Exception {
        AsyncOperation asyncOperation = new AsyncOperation();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return asyncOperation;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("CreationTime", targetDepth)) {
                    asyncOperation.setCreationTime(SimpleTypeStaxUnmarshallers.DateStaxUnmarshallerFactory.getInstance((String)"iso8601").unmarshall(context));
                    continue;
                }
                if (context.testExpression("Operation", targetDepth)) {
                    asyncOperation.setOperation(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("RequestTokenARN", targetDepth)) {
                    asyncOperation.setRequestTokenARN(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("RequestParameters", targetDepth)) {
                    asyncOperation.setRequestParameters(AsyncRequestParametersStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("RequestStatus", targetDepth)) {
                    asyncOperation.setRequestStatus(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("ResponseDetails", targetDepth)) continue;
                asyncOperation.setResponseDetails(AsyncResponseDetailsStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return asyncOperation;
    }

    public static AsyncOperationStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new AsyncOperationStaxUnmarshaller();
        }
        return instance;
    }
}

