/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.model;

import com.amazonaws.services.s3control.model.LifecycleRule;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class LifecycleConfiguration
implements Serializable,
Cloneable {
    private List<LifecycleRule> rules;

    public List<LifecycleRule> getRules() {
        return this.rules;
    }

    public void setRules(Collection<LifecycleRule> rules) {
        if (rules == null) {
            this.rules = null;
            return;
        }
        this.rules = new ArrayList<LifecycleRule>(rules);
    }

    public LifecycleConfiguration withRules(LifecycleRule ... rules) {
        if (this.rules == null) {
            this.setRules(new ArrayList<LifecycleRule>(rules.length));
        }
        for (LifecycleRule ele : rules) {
            this.rules.add(ele);
        }
        return this;
    }

    public LifecycleConfiguration withRules(Collection<LifecycleRule> rules) {
        this.setRules(rules);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRules() != null) {
            sb.append("Rules: ").append(this.getRules());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LifecycleConfiguration)) {
            return false;
        }
        LifecycleConfiguration other = (LifecycleConfiguration)obj;
        if (other.getRules() == null ^ this.getRules() == null) {
            return false;
        }
        return other.getRules() == null || other.getRules().equals(this.getRules());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRules() == null ? 0 : this.getRules().hashCode());
        return hashCode;
    }

    public LifecycleConfiguration clone() {
        try {
            return (LifecycleConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

