/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.s3control.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateAccessGrantsInstanceRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String accountId;
    private String identityCenterArn;
    private List<Tag> tags;

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public CreateAccessGrantsInstanceRequest withAccountId(String accountId) {
        this.setAccountId(accountId);
        return this;
    }

    public void setIdentityCenterArn(String identityCenterArn) {
        this.identityCenterArn = identityCenterArn;
    }

    public String getIdentityCenterArn() {
        return this.identityCenterArn;
    }

    public CreateAccessGrantsInstanceRequest withIdentityCenterArn(String identityCenterArn) {
        this.setIdentityCenterArn(identityCenterArn);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreateAccessGrantsInstanceRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateAccessGrantsInstanceRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAccountId() != null) {
            sb.append("AccountId: ").append(this.getAccountId()).append(",");
        }
        if (this.getIdentityCenterArn() != null) {
            sb.append("IdentityCenterArn: ").append(this.getIdentityCenterArn()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAccessGrantsInstanceRequest)) {
            return false;
        }
        CreateAccessGrantsInstanceRequest other = (CreateAccessGrantsInstanceRequest)obj;
        if (other.getAccountId() == null ^ this.getAccountId() == null) {
            return false;
        }
        if (other.getAccountId() != null && !other.getAccountId().equals(this.getAccountId())) {
            return false;
        }
        if (other.getIdentityCenterArn() == null ^ this.getIdentityCenterArn() == null) {
            return false;
        }
        if (other.getIdentityCenterArn() != null && !other.getIdentityCenterArn().equals(this.getIdentityCenterArn())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAccountId() == null ? 0 : this.getAccountId().hashCode());
        hashCode = 31 * hashCode + (this.getIdentityCenterArn() == null ? 0 : this.getIdentityCenterArn().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreateAccessGrantsInstanceRequest clone() {
        return (CreateAccessGrantsInstanceRequest)super.clone();
    }
}

