/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.internal.handlers;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.handlers.RequestHandler2;
import com.amazonaws.services.s3control.model.ListTagsForResourceRequest;
import com.amazonaws.services.s3control.model.TagResourceRequest;
import com.amazonaws.services.s3control.model.UntagResourceRequest;
import com.amazonaws.util.SdkHttpUtils;

public class ArnHandler
extends RequestHandler2 {
    public void beforeRequest(Request<?> request) {
        AmazonWebServiceRequest original = request.getOriginalRequest();
        if (original instanceof TagResourceRequest) {
            TagResourceRequest tagResourceRequest = (TagResourceRequest)original;
            this.updateResourcePath(request, tagResourceRequest.getResourceArn());
        } else if (original instanceof ListTagsForResourceRequest) {
            ListTagsForResourceRequest listTagsForResourceRequest = (ListTagsForResourceRequest)original;
            this.updateResourcePath(request, listTagsForResourceRequest.getResourceArn());
        } else if (original instanceof UntagResourceRequest) {
            UntagResourceRequest untagResourceRequest = (UntagResourceRequest)original;
            this.updateResourcePath(request, untagResourceRequest.getResourceArn());
        }
    }

    private void updateResourcePath(Request<?> request, String arn) {
        String encodedArn = SdkHttpUtils.urlEncode((String)arn, (boolean)true);
        String resourcePath = request.getResourcePath().replace(arn, encodedArn);
        request.setResourcePath(resourcePath);
    }
}

