/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.route53.model.CidrCollectionChangeAction;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class CidrCollectionChange
implements Serializable,
Cloneable {
    private String locationName;
    private String action;
    private SdkInternalList<String> cidrList;

    public void setLocationName(String locationName) {
        this.locationName = locationName;
    }

    public String getLocationName() {
        return this.locationName;
    }

    public CidrCollectionChange withLocationName(String locationName) {
        this.setLocationName(locationName);
        return this;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getAction() {
        return this.action;
    }

    public CidrCollectionChange withAction(String action) {
        this.setAction(action);
        return this;
    }

    public CidrCollectionChange withAction(CidrCollectionChangeAction action) {
        this.action = action.toString();
        return this;
    }

    public List<String> getCidrList() {
        if (this.cidrList == null) {
            this.cidrList = new SdkInternalList();
        }
        return this.cidrList;
    }

    public void setCidrList(Collection<String> cidrList) {
        if (cidrList == null) {
            this.cidrList = null;
            return;
        }
        this.cidrList = new SdkInternalList(cidrList);
    }

    public CidrCollectionChange withCidrList(String ... cidrList) {
        if (this.cidrList == null) {
            this.setCidrList((Collection<String>)new SdkInternalList(cidrList.length));
        }
        for (String ele : cidrList) {
            this.cidrList.add((Object)ele);
        }
        return this;
    }

    public CidrCollectionChange withCidrList(Collection<String> cidrList) {
        this.setCidrList(cidrList);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getLocationName() != null) {
            sb.append("LocationName: ").append(this.getLocationName()).append(",");
        }
        if (this.getAction() != null) {
            sb.append("Action: ").append(this.getAction()).append(",");
        }
        if (this.getCidrList() != null) {
            sb.append("CidrList: ").append(this.getCidrList());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CidrCollectionChange)) {
            return false;
        }
        CidrCollectionChange other = (CidrCollectionChange)obj;
        if (other.getLocationName() == null ^ this.getLocationName() == null) {
            return false;
        }
        if (other.getLocationName() != null && !other.getLocationName().equals(this.getLocationName())) {
            return false;
        }
        if (other.getAction() == null ^ this.getAction() == null) {
            return false;
        }
        if (other.getAction() != null && !other.getAction().equals(this.getAction())) {
            return false;
        }
        if (other.getCidrList() == null ^ this.getCidrList() == null) {
            return false;
        }
        return other.getCidrList() == null || other.getCidrList().equals(this.getCidrList());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getLocationName() == null ? 0 : this.getLocationName().hashCode());
        hashCode = 31 * hashCode + (this.getAction() == null ? 0 : this.getAction().hashCode());
        hashCode = 31 * hashCode + (this.getCidrList() == null ? 0 : this.getCidrList().hashCode());
        return hashCode;
    }

    public CidrCollectionChange clone() {
        try {
            return (CidrCollectionChange)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

