/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53domains.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.route53domains.model.ListOperationsSortAttributeName;
import com.amazonaws.services.route53domains.model.OperationStatus;
import com.amazonaws.services.route53domains.model.OperationType;
import com.amazonaws.services.route53domains.model.SortOrder;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class ListOperationsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private Date submittedSince;
    private String marker;
    private Integer maxItems;
    private SdkInternalList<String> status;
    private SdkInternalList<String> type;
    private String sortBy;
    private String sortOrder;

    public void setSubmittedSince(Date submittedSince) {
        this.submittedSince = submittedSince;
    }

    public Date getSubmittedSince() {
        return this.submittedSince;
    }

    public ListOperationsRequest withSubmittedSince(Date submittedSince) {
        this.setSubmittedSince(submittedSince);
        return this;
    }

    public void setMarker(String marker) {
        this.marker = marker;
    }

    public String getMarker() {
        return this.marker;
    }

    public ListOperationsRequest withMarker(String marker) {
        this.setMarker(marker);
        return this;
    }

    public void setMaxItems(Integer maxItems) {
        this.maxItems = maxItems;
    }

    public Integer getMaxItems() {
        return this.maxItems;
    }

    public ListOperationsRequest withMaxItems(Integer maxItems) {
        this.setMaxItems(maxItems);
        return this;
    }

    public List<String> getStatus() {
        if (this.status == null) {
            this.status = new SdkInternalList();
        }
        return this.status;
    }

    public void setStatus(Collection<String> status) {
        if (status == null) {
            this.status = null;
            return;
        }
        this.status = new SdkInternalList(status);
    }

    public ListOperationsRequest withStatus(String ... status) {
        if (this.status == null) {
            this.setStatus((Collection<String>)new SdkInternalList(status.length));
        }
        for (String ele : status) {
            this.status.add((Object)ele);
        }
        return this;
    }

    public ListOperationsRequest withStatus(Collection<String> status) {
        this.setStatus(status);
        return this;
    }

    public ListOperationsRequest withStatus(OperationStatus ... status) {
        SdkInternalList statusCopy = new SdkInternalList(status.length);
        for (OperationStatus value : status) {
            statusCopy.add((Object)value.toString());
        }
        if (this.getStatus() == null) {
            this.setStatus((Collection<String>)statusCopy);
        } else {
            this.getStatus().addAll((Collection<String>)statusCopy);
        }
        return this;
    }

    public List<String> getType() {
        if (this.type == null) {
            this.type = new SdkInternalList();
        }
        return this.type;
    }

    public void setType(Collection<String> type) {
        if (type == null) {
            this.type = null;
            return;
        }
        this.type = new SdkInternalList(type);
    }

    public ListOperationsRequest withType(String ... type) {
        if (this.type == null) {
            this.setType((Collection<String>)new SdkInternalList(type.length));
        }
        for (String ele : type) {
            this.type.add((Object)ele);
        }
        return this;
    }

    public ListOperationsRequest withType(Collection<String> type) {
        this.setType(type);
        return this;
    }

    public ListOperationsRequest withType(OperationType ... type) {
        SdkInternalList typeCopy = new SdkInternalList(type.length);
        for (OperationType value : type) {
            typeCopy.add((Object)value.toString());
        }
        if (this.getType() == null) {
            this.setType((Collection<String>)typeCopy);
        } else {
            this.getType().addAll((Collection<String>)typeCopy);
        }
        return this;
    }

    public void setSortBy(String sortBy) {
        this.sortBy = sortBy;
    }

    public String getSortBy() {
        return this.sortBy;
    }

    public ListOperationsRequest withSortBy(String sortBy) {
        this.setSortBy(sortBy);
        return this;
    }

    public ListOperationsRequest withSortBy(ListOperationsSortAttributeName sortBy) {
        this.sortBy = sortBy.toString();
        return this;
    }

    public void setSortOrder(String sortOrder) {
        this.sortOrder = sortOrder;
    }

    public String getSortOrder() {
        return this.sortOrder;
    }

    public ListOperationsRequest withSortOrder(String sortOrder) {
        this.setSortOrder(sortOrder);
        return this;
    }

    public ListOperationsRequest withSortOrder(SortOrder sortOrder) {
        this.sortOrder = sortOrder.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSubmittedSince() != null) {
            sb.append("SubmittedSince: ").append(this.getSubmittedSince()).append(",");
        }
        if (this.getMarker() != null) {
            sb.append("Marker: ").append(this.getMarker()).append(",");
        }
        if (this.getMaxItems() != null) {
            sb.append("MaxItems: ").append(this.getMaxItems()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType()).append(",");
        }
        if (this.getSortBy() != null) {
            sb.append("SortBy: ").append(this.getSortBy()).append(",");
        }
        if (this.getSortOrder() != null) {
            sb.append("SortOrder: ").append(this.getSortOrder());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOperationsRequest)) {
            return false;
        }
        ListOperationsRequest other = (ListOperationsRequest)obj;
        if (other.getSubmittedSince() == null ^ this.getSubmittedSince() == null) {
            return false;
        }
        if (other.getSubmittedSince() != null && !other.getSubmittedSince().equals(this.getSubmittedSince())) {
            return false;
        }
        if (other.getMarker() == null ^ this.getMarker() == null) {
            return false;
        }
        if (other.getMarker() != null && !other.getMarker().equals(this.getMarker())) {
            return false;
        }
        if (other.getMaxItems() == null ^ this.getMaxItems() == null) {
            return false;
        }
        if (other.getMaxItems() != null && !other.getMaxItems().equals(this.getMaxItems())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getSortBy() == null ^ this.getSortBy() == null) {
            return false;
        }
        if (other.getSortBy() != null && !other.getSortBy().equals(this.getSortBy())) {
            return false;
        }
        if (other.getSortOrder() == null ^ this.getSortOrder() == null) {
            return false;
        }
        return other.getSortOrder() == null || other.getSortOrder().equals(this.getSortOrder());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSubmittedSince() == null ? 0 : this.getSubmittedSince().hashCode());
        hashCode = 31 * hashCode + (this.getMarker() == null ? 0 : this.getMarker().hashCode());
        hashCode = 31 * hashCode + (this.getMaxItems() == null ? 0 : this.getMaxItems().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getSortBy() == null ? 0 : this.getSortBy().hashCode());
        hashCode = 31 * hashCode + (this.getSortOrder() == null ? 0 : this.getSortOrder().hashCode());
        return hashCode;
    }

    public ListOperationsRequest clone() {
        return (ListOperationsRequest)super.clone();
    }
}

