/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.resiliencehub.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.resiliencehub.model.TerraformSource;

@SdkInternalApi
public class TerraformSourceMarshaller {
    private static final MarshallingInfo<String> S3STATEFILEURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("s3StateFileUrl").build();
    private static final TerraformSourceMarshaller instance = new TerraformSourceMarshaller();

    public static TerraformSourceMarshaller getInstance() {
        return instance;
    }

    public void marshall(TerraformSource terraformSource, ProtocolMarshaller protocolMarshaller) {
        if (terraformSource == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)terraformSource.getS3StateFileUrl(), S3STATEFILEURL_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

