/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.resiliencehub.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.resiliencehub.model.ResiliencyScore;
import java.util.Map;

@SdkInternalApi
public class ResiliencyScoreMarshaller {
    private static final MarshallingInfo<Map> COMPONENTSCORE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("componentScore").build();
    private static final MarshallingInfo<Map> DISRUPTIONSCORE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("disruptionScore").build();
    private static final MarshallingInfo<Double> SCORE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("score").build();
    private static final ResiliencyScoreMarshaller instance = new ResiliencyScoreMarshaller();

    public static ResiliencyScoreMarshaller getInstance() {
        return instance;
    }

    public void marshall(ResiliencyScore resiliencyScore, ProtocolMarshaller protocolMarshaller) {
        if (resiliencyScore == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(resiliencyScore.getComponentScore(), COMPONENTSCORE_BINDING);
            protocolMarshaller.marshall(resiliencyScore.getDisruptionScore(), DISRUPTIONSCORE_BINDING);
            protocolMarshaller.marshall((Object)resiliencyScore.getScore(), SCORE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

