/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.resiliencehub.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.resiliencehub.model.RenderRecommendationType;
import com.amazonaws.services.resiliencehub.model.TemplateFormat;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreateRecommendationTemplateRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String assessmentArn;
    private String bucketName;
    private String clientToken;
    private String format;
    private String name;
    private List<String> recommendationIds;
    private List<String> recommendationTypes;
    private Map<String, String> tags;

    public void setAssessmentArn(String assessmentArn) {
        this.assessmentArn = assessmentArn;
    }

    public String getAssessmentArn() {
        return this.assessmentArn;
    }

    public CreateRecommendationTemplateRequest withAssessmentArn(String assessmentArn) {
        this.setAssessmentArn(assessmentArn);
        return this;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public CreateRecommendationTemplateRequest withBucketName(String bucketName) {
        this.setBucketName(bucketName);
        return this;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public CreateRecommendationTemplateRequest withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getFormat() {
        return this.format;
    }

    public CreateRecommendationTemplateRequest withFormat(String format) {
        this.setFormat(format);
        return this;
    }

    public CreateRecommendationTemplateRequest withFormat(TemplateFormat format) {
        this.format = format.toString();
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public CreateRecommendationTemplateRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public List<String> getRecommendationIds() {
        return this.recommendationIds;
    }

    public void setRecommendationIds(Collection<String> recommendationIds) {
        if (recommendationIds == null) {
            this.recommendationIds = null;
            return;
        }
        this.recommendationIds = new ArrayList<String>(recommendationIds);
    }

    public CreateRecommendationTemplateRequest withRecommendationIds(String ... recommendationIds) {
        if (this.recommendationIds == null) {
            this.setRecommendationIds(new ArrayList<String>(recommendationIds.length));
        }
        for (String ele : recommendationIds) {
            this.recommendationIds.add(ele);
        }
        return this;
    }

    public CreateRecommendationTemplateRequest withRecommendationIds(Collection<String> recommendationIds) {
        this.setRecommendationIds(recommendationIds);
        return this;
    }

    public List<String> getRecommendationTypes() {
        return this.recommendationTypes;
    }

    public void setRecommendationTypes(Collection<String> recommendationTypes) {
        if (recommendationTypes == null) {
            this.recommendationTypes = null;
            return;
        }
        this.recommendationTypes = new ArrayList<String>(recommendationTypes);
    }

    public CreateRecommendationTemplateRequest withRecommendationTypes(String ... recommendationTypes) {
        if (this.recommendationTypes == null) {
            this.setRecommendationTypes(new ArrayList<String>(recommendationTypes.length));
        }
        for (String ele : recommendationTypes) {
            this.recommendationTypes.add(ele);
        }
        return this;
    }

    public CreateRecommendationTemplateRequest withRecommendationTypes(Collection<String> recommendationTypes) {
        this.setRecommendationTypes(recommendationTypes);
        return this;
    }

    public CreateRecommendationTemplateRequest withRecommendationTypes(RenderRecommendationType ... recommendationTypes) {
        ArrayList<String> recommendationTypesCopy = new ArrayList<String>(recommendationTypes.length);
        for (RenderRecommendationType value : recommendationTypes) {
            recommendationTypesCopy.add(value.toString());
        }
        if (this.getRecommendationTypes() == null) {
            this.setRecommendationTypes(recommendationTypesCopy);
        } else {
            this.getRecommendationTypes().addAll(recommendationTypesCopy);
        }
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public CreateRecommendationTemplateRequest withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public CreateRecommendationTemplateRequest addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public CreateRecommendationTemplateRequest clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAssessmentArn() != null) {
            sb.append("AssessmentArn: ").append(this.getAssessmentArn()).append(",");
        }
        if (this.getBucketName() != null) {
            sb.append("BucketName: ").append(this.getBucketName()).append(",");
        }
        if (this.getClientToken() != null) {
            sb.append("ClientToken: ").append(this.getClientToken()).append(",");
        }
        if (this.getFormat() != null) {
            sb.append("Format: ").append(this.getFormat()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getRecommendationIds() != null) {
            sb.append("RecommendationIds: ").append(this.getRecommendationIds()).append(",");
        }
        if (this.getRecommendationTypes() != null) {
            sb.append("RecommendationTypes: ").append(this.getRecommendationTypes()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append("***Sensitive Data Redacted***");
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRecommendationTemplateRequest)) {
            return false;
        }
        CreateRecommendationTemplateRequest other = (CreateRecommendationTemplateRequest)obj;
        if (other.getAssessmentArn() == null ^ this.getAssessmentArn() == null) {
            return false;
        }
        if (other.getAssessmentArn() != null && !other.getAssessmentArn().equals(this.getAssessmentArn())) {
            return false;
        }
        if (other.getBucketName() == null ^ this.getBucketName() == null) {
            return false;
        }
        if (other.getBucketName() != null && !other.getBucketName().equals(this.getBucketName())) {
            return false;
        }
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        if (other.getClientToken() != null && !other.getClientToken().equals(this.getClientToken())) {
            return false;
        }
        if (other.getFormat() == null ^ this.getFormat() == null) {
            return false;
        }
        if (other.getFormat() != null && !other.getFormat().equals(this.getFormat())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getRecommendationIds() == null ^ this.getRecommendationIds() == null) {
            return false;
        }
        if (other.getRecommendationIds() != null && !other.getRecommendationIds().equals(this.getRecommendationIds())) {
            return false;
        }
        if (other.getRecommendationTypes() == null ^ this.getRecommendationTypes() == null) {
            return false;
        }
        if (other.getRecommendationTypes() != null && !other.getRecommendationTypes().equals(this.getRecommendationTypes())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAssessmentArn() == null ? 0 : this.getAssessmentArn().hashCode());
        hashCode = 31 * hashCode + (this.getBucketName() == null ? 0 : this.getBucketName().hashCode());
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        hashCode = 31 * hashCode + (this.getFormat() == null ? 0 : this.getFormat().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getRecommendationIds() == null ? 0 : this.getRecommendationIds().hashCode());
        hashCode = 31 * hashCode + (this.getRecommendationTypes() == null ? 0 : this.getRecommendationTypes().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreateRecommendationTemplateRequest clone() {
        return (CreateRecommendationTemplateRequest)super.clone();
    }
}

