/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.resiliencehub.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.resiliencehub.model.DataLocationConstraint;
import com.amazonaws.services.resiliencehub.model.FailurePolicy;
import com.amazonaws.services.resiliencehub.model.ResiliencyPolicyTier;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class CreateResiliencyPolicyRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String clientToken;
    private String dataLocationConstraint;
    private Map<String, FailurePolicy> policy;
    private String policyDescription;
    private String policyName;
    private Map<String, String> tags;
    private String tier;

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public CreateResiliencyPolicyRequest withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    public void setDataLocationConstraint(String dataLocationConstraint) {
        this.dataLocationConstraint = dataLocationConstraint;
    }

    public String getDataLocationConstraint() {
        return this.dataLocationConstraint;
    }

    public CreateResiliencyPolicyRequest withDataLocationConstraint(String dataLocationConstraint) {
        this.setDataLocationConstraint(dataLocationConstraint);
        return this;
    }

    public CreateResiliencyPolicyRequest withDataLocationConstraint(DataLocationConstraint dataLocationConstraint) {
        this.dataLocationConstraint = dataLocationConstraint.toString();
        return this;
    }

    public Map<String, FailurePolicy> getPolicy() {
        return this.policy;
    }

    public void setPolicy(Map<String, FailurePolicy> policy) {
        this.policy = policy;
    }

    public CreateResiliencyPolicyRequest withPolicy(Map<String, FailurePolicy> policy) {
        this.setPolicy(policy);
        return this;
    }

    public CreateResiliencyPolicyRequest addPolicyEntry(String key, FailurePolicy value) {
        if (null == this.policy) {
            this.policy = new HashMap<String, FailurePolicy>();
        }
        if (this.policy.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.policy.put(key, value);
        return this;
    }

    public CreateResiliencyPolicyRequest clearPolicyEntries() {
        this.policy = null;
        return this;
    }

    public void setPolicyDescription(String policyDescription) {
        this.policyDescription = policyDescription;
    }

    public String getPolicyDescription() {
        return this.policyDescription;
    }

    public CreateResiliencyPolicyRequest withPolicyDescription(String policyDescription) {
        this.setPolicyDescription(policyDescription);
        return this;
    }

    public void setPolicyName(String policyName) {
        this.policyName = policyName;
    }

    public String getPolicyName() {
        return this.policyName;
    }

    public CreateResiliencyPolicyRequest withPolicyName(String policyName) {
        this.setPolicyName(policyName);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public CreateResiliencyPolicyRequest withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public CreateResiliencyPolicyRequest addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public CreateResiliencyPolicyRequest clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public void setTier(String tier) {
        this.tier = tier;
    }

    public String getTier() {
        return this.tier;
    }

    public CreateResiliencyPolicyRequest withTier(String tier) {
        this.setTier(tier);
        return this;
    }

    public CreateResiliencyPolicyRequest withTier(ResiliencyPolicyTier tier) {
        this.tier = tier.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getClientToken() != null) {
            sb.append("ClientToken: ").append(this.getClientToken()).append(",");
        }
        if (this.getDataLocationConstraint() != null) {
            sb.append("DataLocationConstraint: ").append(this.getDataLocationConstraint()).append(",");
        }
        if (this.getPolicy() != null) {
            sb.append("Policy: ").append(this.getPolicy()).append(",");
        }
        if (this.getPolicyDescription() != null) {
            sb.append("PolicyDescription: ").append(this.getPolicyDescription()).append(",");
        }
        if (this.getPolicyName() != null) {
            sb.append("PolicyName: ").append(this.getPolicyName()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getTier() != null) {
            sb.append("Tier: ").append(this.getTier());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateResiliencyPolicyRequest)) {
            return false;
        }
        CreateResiliencyPolicyRequest other = (CreateResiliencyPolicyRequest)obj;
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        if (other.getClientToken() != null && !other.getClientToken().equals(this.getClientToken())) {
            return false;
        }
        if (other.getDataLocationConstraint() == null ^ this.getDataLocationConstraint() == null) {
            return false;
        }
        if (other.getDataLocationConstraint() != null && !other.getDataLocationConstraint().equals(this.getDataLocationConstraint())) {
            return false;
        }
        if (other.getPolicy() == null ^ this.getPolicy() == null) {
            return false;
        }
        if (other.getPolicy() != null && !other.getPolicy().equals(this.getPolicy())) {
            return false;
        }
        if (other.getPolicyDescription() == null ^ this.getPolicyDescription() == null) {
            return false;
        }
        if (other.getPolicyDescription() != null && !other.getPolicyDescription().equals(this.getPolicyDescription())) {
            return false;
        }
        if (other.getPolicyName() == null ^ this.getPolicyName() == null) {
            return false;
        }
        if (other.getPolicyName() != null && !other.getPolicyName().equals(this.getPolicyName())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getTier() == null ^ this.getTier() == null) {
            return false;
        }
        return other.getTier() == null || other.getTier().equals(this.getTier());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        hashCode = 31 * hashCode + (this.getDataLocationConstraint() == null ? 0 : this.getDataLocationConstraint().hashCode());
        hashCode = 31 * hashCode + (this.getPolicy() == null ? 0 : this.getPolicy().hashCode());
        hashCode = 31 * hashCode + (this.getPolicyDescription() == null ? 0 : this.getPolicyDescription().hashCode());
        hashCode = 31 * hashCode + (this.getPolicyName() == null ? 0 : this.getPolicyName().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getTier() == null ? 0 : this.getTier().hashCode());
        return hashCode;
    }

    public CreateResiliencyPolicyRequest clone() {
        return (CreateResiliencyPolicyRequest)super.clone();
    }
}

