/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rekognition.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.rekognition.model.NotificationChannel;
import com.amazonaws.services.rekognition.model.SegmentType;
import com.amazonaws.services.rekognition.model.StartSegmentDetectionFilters;
import com.amazonaws.services.rekognition.model.Video;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class StartSegmentDetectionRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private Video video;
    private String clientRequestToken;
    private NotificationChannel notificationChannel;
    private String jobTag;
    private StartSegmentDetectionFilters filters;
    private List<String> segmentTypes;

    public void setVideo(Video video) {
        this.video = video;
    }

    public Video getVideo() {
        return this.video;
    }

    public StartSegmentDetectionRequest withVideo(Video video) {
        this.setVideo(video);
        return this;
    }

    public void setClientRequestToken(String clientRequestToken) {
        this.clientRequestToken = clientRequestToken;
    }

    public String getClientRequestToken() {
        return this.clientRequestToken;
    }

    public StartSegmentDetectionRequest withClientRequestToken(String clientRequestToken) {
        this.setClientRequestToken(clientRequestToken);
        return this;
    }

    public void setNotificationChannel(NotificationChannel notificationChannel) {
        this.notificationChannel = notificationChannel;
    }

    public NotificationChannel getNotificationChannel() {
        return this.notificationChannel;
    }

    public StartSegmentDetectionRequest withNotificationChannel(NotificationChannel notificationChannel) {
        this.setNotificationChannel(notificationChannel);
        return this;
    }

    public void setJobTag(String jobTag) {
        this.jobTag = jobTag;
    }

    public String getJobTag() {
        return this.jobTag;
    }

    public StartSegmentDetectionRequest withJobTag(String jobTag) {
        this.setJobTag(jobTag);
        return this;
    }

    public void setFilters(StartSegmentDetectionFilters filters) {
        this.filters = filters;
    }

    public StartSegmentDetectionFilters getFilters() {
        return this.filters;
    }

    public StartSegmentDetectionRequest withFilters(StartSegmentDetectionFilters filters) {
        this.setFilters(filters);
        return this;
    }

    public List<String> getSegmentTypes() {
        return this.segmentTypes;
    }

    public void setSegmentTypes(Collection<String> segmentTypes) {
        if (segmentTypes == null) {
            this.segmentTypes = null;
            return;
        }
        this.segmentTypes = new ArrayList<String>(segmentTypes);
    }

    public StartSegmentDetectionRequest withSegmentTypes(String ... segmentTypes) {
        if (this.segmentTypes == null) {
            this.setSegmentTypes(new ArrayList<String>(segmentTypes.length));
        }
        for (String ele : segmentTypes) {
            this.segmentTypes.add(ele);
        }
        return this;
    }

    public StartSegmentDetectionRequest withSegmentTypes(Collection<String> segmentTypes) {
        this.setSegmentTypes(segmentTypes);
        return this;
    }

    public StartSegmentDetectionRequest withSegmentTypes(SegmentType ... segmentTypes) {
        ArrayList<String> segmentTypesCopy = new ArrayList<String>(segmentTypes.length);
        for (SegmentType value : segmentTypes) {
            segmentTypesCopy.add(value.toString());
        }
        if (this.getSegmentTypes() == null) {
            this.setSegmentTypes(segmentTypesCopy);
        } else {
            this.getSegmentTypes().addAll(segmentTypesCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getVideo() != null) {
            sb.append("Video: ").append(this.getVideo()).append(",");
        }
        if (this.getClientRequestToken() != null) {
            sb.append("ClientRequestToken: ").append(this.getClientRequestToken()).append(",");
        }
        if (this.getNotificationChannel() != null) {
            sb.append("NotificationChannel: ").append(this.getNotificationChannel()).append(",");
        }
        if (this.getJobTag() != null) {
            sb.append("JobTag: ").append(this.getJobTag()).append(",");
        }
        if (this.getFilters() != null) {
            sb.append("Filters: ").append(this.getFilters()).append(",");
        }
        if (this.getSegmentTypes() != null) {
            sb.append("SegmentTypes: ").append(this.getSegmentTypes());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartSegmentDetectionRequest)) {
            return false;
        }
        StartSegmentDetectionRequest other = (StartSegmentDetectionRequest)obj;
        if (other.getVideo() == null ^ this.getVideo() == null) {
            return false;
        }
        if (other.getVideo() != null && !other.getVideo().equals(this.getVideo())) {
            return false;
        }
        if (other.getClientRequestToken() == null ^ this.getClientRequestToken() == null) {
            return false;
        }
        if (other.getClientRequestToken() != null && !other.getClientRequestToken().equals(this.getClientRequestToken())) {
            return false;
        }
        if (other.getNotificationChannel() == null ^ this.getNotificationChannel() == null) {
            return false;
        }
        if (other.getNotificationChannel() != null && !other.getNotificationChannel().equals(this.getNotificationChannel())) {
            return false;
        }
        if (other.getJobTag() == null ^ this.getJobTag() == null) {
            return false;
        }
        if (other.getJobTag() != null && !other.getJobTag().equals(this.getJobTag())) {
            return false;
        }
        if (other.getFilters() == null ^ this.getFilters() == null) {
            return false;
        }
        if (other.getFilters() != null && !other.getFilters().equals(this.getFilters())) {
            return false;
        }
        if (other.getSegmentTypes() == null ^ this.getSegmentTypes() == null) {
            return false;
        }
        return other.getSegmentTypes() == null || other.getSegmentTypes().equals(this.getSegmentTypes());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getVideo() == null ? 0 : this.getVideo().hashCode());
        hashCode = 31 * hashCode + (this.getClientRequestToken() == null ? 0 : this.getClientRequestToken().hashCode());
        hashCode = 31 * hashCode + (this.getNotificationChannel() == null ? 0 : this.getNotificationChannel().hashCode());
        hashCode = 31 * hashCode + (this.getJobTag() == null ? 0 : this.getJobTag().hashCode());
        hashCode = 31 * hashCode + (this.getFilters() == null ? 0 : this.getFilters().hashCode());
        hashCode = 31 * hashCode + (this.getSegmentTypes() == null ? 0 : this.getSegmentTypes().hashCode());
        return hashCode;
    }

    public StartSegmentDetectionRequest clone() {
        return (StartSegmentDetectionRequest)super.clone();
    }
}

