/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rekognition.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.rekognition.model.ContentType;
import com.amazonaws.services.rekognition.model.ModerationLabel;
import com.amazonaws.services.rekognition.model.transform.ContentModerationDetectionMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ContentModerationDetection
implements Serializable,
Cloneable,
StructuredPojo {
    private Long timestamp;
    private ModerationLabel moderationLabel;
    private Long startTimestampMillis;
    private Long endTimestampMillis;
    private Long durationMillis;
    private List<ContentType> contentTypes;

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public ContentModerationDetection withTimestamp(Long timestamp) {
        this.setTimestamp(timestamp);
        return this;
    }

    public void setModerationLabel(ModerationLabel moderationLabel) {
        this.moderationLabel = moderationLabel;
    }

    public ModerationLabel getModerationLabel() {
        return this.moderationLabel;
    }

    public ContentModerationDetection withModerationLabel(ModerationLabel moderationLabel) {
        this.setModerationLabel(moderationLabel);
        return this;
    }

    public void setStartTimestampMillis(Long startTimestampMillis) {
        this.startTimestampMillis = startTimestampMillis;
    }

    public Long getStartTimestampMillis() {
        return this.startTimestampMillis;
    }

    public ContentModerationDetection withStartTimestampMillis(Long startTimestampMillis) {
        this.setStartTimestampMillis(startTimestampMillis);
        return this;
    }

    public void setEndTimestampMillis(Long endTimestampMillis) {
        this.endTimestampMillis = endTimestampMillis;
    }

    public Long getEndTimestampMillis() {
        return this.endTimestampMillis;
    }

    public ContentModerationDetection withEndTimestampMillis(Long endTimestampMillis) {
        this.setEndTimestampMillis(endTimestampMillis);
        return this;
    }

    public void setDurationMillis(Long durationMillis) {
        this.durationMillis = durationMillis;
    }

    public Long getDurationMillis() {
        return this.durationMillis;
    }

    public ContentModerationDetection withDurationMillis(Long durationMillis) {
        this.setDurationMillis(durationMillis);
        return this;
    }

    public List<ContentType> getContentTypes() {
        return this.contentTypes;
    }

    public void setContentTypes(Collection<ContentType> contentTypes) {
        if (contentTypes == null) {
            this.contentTypes = null;
            return;
        }
        this.contentTypes = new ArrayList<ContentType>(contentTypes);
    }

    public ContentModerationDetection withContentTypes(ContentType ... contentTypes) {
        if (this.contentTypes == null) {
            this.setContentTypes(new ArrayList<ContentType>(contentTypes.length));
        }
        for (ContentType ele : contentTypes) {
            this.contentTypes.add(ele);
        }
        return this;
    }

    public ContentModerationDetection withContentTypes(Collection<ContentType> contentTypes) {
        this.setContentTypes(contentTypes);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTimestamp() != null) {
            sb.append("Timestamp: ").append(this.getTimestamp()).append(",");
        }
        if (this.getModerationLabel() != null) {
            sb.append("ModerationLabel: ").append(this.getModerationLabel()).append(",");
        }
        if (this.getStartTimestampMillis() != null) {
            sb.append("StartTimestampMillis: ").append(this.getStartTimestampMillis()).append(",");
        }
        if (this.getEndTimestampMillis() != null) {
            sb.append("EndTimestampMillis: ").append(this.getEndTimestampMillis()).append(",");
        }
        if (this.getDurationMillis() != null) {
            sb.append("DurationMillis: ").append(this.getDurationMillis()).append(",");
        }
        if (this.getContentTypes() != null) {
            sb.append("ContentTypes: ").append(this.getContentTypes());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContentModerationDetection)) {
            return false;
        }
        ContentModerationDetection other = (ContentModerationDetection)obj;
        if (other.getTimestamp() == null ^ this.getTimestamp() == null) {
            return false;
        }
        if (other.getTimestamp() != null && !other.getTimestamp().equals(this.getTimestamp())) {
            return false;
        }
        if (other.getModerationLabel() == null ^ this.getModerationLabel() == null) {
            return false;
        }
        if (other.getModerationLabel() != null && !other.getModerationLabel().equals(this.getModerationLabel())) {
            return false;
        }
        if (other.getStartTimestampMillis() == null ^ this.getStartTimestampMillis() == null) {
            return false;
        }
        if (other.getStartTimestampMillis() != null && !other.getStartTimestampMillis().equals(this.getStartTimestampMillis())) {
            return false;
        }
        if (other.getEndTimestampMillis() == null ^ this.getEndTimestampMillis() == null) {
            return false;
        }
        if (other.getEndTimestampMillis() != null && !other.getEndTimestampMillis().equals(this.getEndTimestampMillis())) {
            return false;
        }
        if (other.getDurationMillis() == null ^ this.getDurationMillis() == null) {
            return false;
        }
        if (other.getDurationMillis() != null && !other.getDurationMillis().equals(this.getDurationMillis())) {
            return false;
        }
        if (other.getContentTypes() == null ^ this.getContentTypes() == null) {
            return false;
        }
        return other.getContentTypes() == null || other.getContentTypes().equals(this.getContentTypes());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTimestamp() == null ? 0 : this.getTimestamp().hashCode());
        hashCode = 31 * hashCode + (this.getModerationLabel() == null ? 0 : this.getModerationLabel().hashCode());
        hashCode = 31 * hashCode + (this.getStartTimestampMillis() == null ? 0 : this.getStartTimestampMillis().hashCode());
        hashCode = 31 * hashCode + (this.getEndTimestampMillis() == null ? 0 : this.getEndTimestampMillis().hashCode());
        hashCode = 31 * hashCode + (this.getDurationMillis() == null ? 0 : this.getDurationMillis().hashCode());
        hashCode = 31 * hashCode + (this.getContentTypes() == null ? 0 : this.getContentTypes().hashCode());
        return hashCode;
    }

    public ContentModerationDetection clone() {
        try {
            return (ContentModerationDetection)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ContentModerationDetectionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

