/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift.waiters;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.jmespath.JmesPathEvaluationVisitor;
import com.amazonaws.jmespath.JmesPathExpression;
import com.amazonaws.jmespath.JmesPathField;
import com.amazonaws.jmespath.JmesPathFlatten;
import com.amazonaws.jmespath.JmesPathProjection;
import com.amazonaws.jmespath.JmesPathVisitor;
import com.amazonaws.jmespath.ObjectMapperSingleton;
import com.amazonaws.services.redshift.model.DescribeClustersResult;
import com.amazonaws.waiters.AcceptorPathMatcher;
import com.amazonaws.waiters.WaiterAcceptor;
import com.amazonaws.waiters.WaiterState;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;

@SdkInternalApi
class ClusterDeleted {
    ClusterDeleted() {
    }

    static class IsModifyingMatcher
    extends WaiterAcceptor<DescribeClustersResult> {
        private static final JsonNode expectedResult;
        private static final JmesPathExpression ast;

        IsModifyingMatcher() {
        }

        public boolean matches(DescribeClustersResult result) {
            JsonNode queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree((Object)result);
            JsonNode finalResult = (JsonNode)ast.accept((JmesPathVisitor)new JmesPathEvaluationVisitor(), (Object)queryNode);
            return AcceptorPathMatcher.pathAny((JsonNode)expectedResult, (JsonNode)finalResult);
        }

        public WaiterState getState() {
            return WaiterState.FAILURE;
        }

        static {
            try {
                expectedResult = ObjectMapperSingleton.getObjectMapper().readTree("\"modifying\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            ast = new JmesPathProjection((JmesPathExpression)new JmesPathFlatten((JmesPathExpression)new JmesPathField("Clusters")), (JmesPathExpression)new JmesPathField("ClusterStatus"));
        }
    }

    static class IsCreatingMatcher
    extends WaiterAcceptor<DescribeClustersResult> {
        private static final JsonNode expectedResult;
        private static final JmesPathExpression ast;

        IsCreatingMatcher() {
        }

        public boolean matches(DescribeClustersResult result) {
            JsonNode queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree((Object)result);
            JsonNode finalResult = (JsonNode)ast.accept((JmesPathVisitor)new JmesPathEvaluationVisitor(), (Object)queryNode);
            return AcceptorPathMatcher.pathAny((JsonNode)expectedResult, (JsonNode)finalResult);
        }

        public WaiterState getState() {
            return WaiterState.FAILURE;
        }

        static {
            try {
                expectedResult = ObjectMapperSingleton.getObjectMapper().readTree("\"creating\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            ast = new JmesPathProjection((JmesPathExpression)new JmesPathFlatten((JmesPathExpression)new JmesPathField("Clusters")), (JmesPathExpression)new JmesPathField("ClusterStatus"));
        }
    }

    static class IsClusterNotFoundMatcher
    extends WaiterAcceptor<DescribeClustersResult> {
        IsClusterNotFoundMatcher() {
        }

        public boolean matches(AmazonServiceException e) {
            return "ClusterNotFound".equals(e.getErrorCode());
        }

        public WaiterState getState() {
            return WaiterState.SUCCESS;
        }
    }
}

