/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.redshift.model.AuthorizationStatus;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class RevokeEndpointAccessResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String grantor;
    private String grantee;
    private String clusterIdentifier;
    private Date authorizeTime;
    private String clusterStatus;
    private String status;
    private Boolean allowedAllVPCs;
    private SdkInternalList<String> allowedVPCs;
    private Integer endpointCount;

    public void setGrantor(String grantor) {
        this.grantor = grantor;
    }

    public String getGrantor() {
        return this.grantor;
    }

    public RevokeEndpointAccessResult withGrantor(String grantor) {
        this.setGrantor(grantor);
        return this;
    }

    public void setGrantee(String grantee) {
        this.grantee = grantee;
    }

    public String getGrantee() {
        return this.grantee;
    }

    public RevokeEndpointAccessResult withGrantee(String grantee) {
        this.setGrantee(grantee);
        return this;
    }

    public void setClusterIdentifier(String clusterIdentifier) {
        this.clusterIdentifier = clusterIdentifier;
    }

    public String getClusterIdentifier() {
        return this.clusterIdentifier;
    }

    public RevokeEndpointAccessResult withClusterIdentifier(String clusterIdentifier) {
        this.setClusterIdentifier(clusterIdentifier);
        return this;
    }

    public void setAuthorizeTime(Date authorizeTime) {
        this.authorizeTime = authorizeTime;
    }

    public Date getAuthorizeTime() {
        return this.authorizeTime;
    }

    public RevokeEndpointAccessResult withAuthorizeTime(Date authorizeTime) {
        this.setAuthorizeTime(authorizeTime);
        return this;
    }

    public void setClusterStatus(String clusterStatus) {
        this.clusterStatus = clusterStatus;
    }

    public String getClusterStatus() {
        return this.clusterStatus;
    }

    public RevokeEndpointAccessResult withClusterStatus(String clusterStatus) {
        this.setClusterStatus(clusterStatus);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public RevokeEndpointAccessResult withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public RevokeEndpointAccessResult withStatus(AuthorizationStatus status) {
        this.status = status.toString();
        return this;
    }

    public void setAllowedAllVPCs(Boolean allowedAllVPCs) {
        this.allowedAllVPCs = allowedAllVPCs;
    }

    public Boolean getAllowedAllVPCs() {
        return this.allowedAllVPCs;
    }

    public RevokeEndpointAccessResult withAllowedAllVPCs(Boolean allowedAllVPCs) {
        this.setAllowedAllVPCs(allowedAllVPCs);
        return this;
    }

    public Boolean isAllowedAllVPCs() {
        return this.allowedAllVPCs;
    }

    public List<String> getAllowedVPCs() {
        if (this.allowedVPCs == null) {
            this.allowedVPCs = new SdkInternalList();
        }
        return this.allowedVPCs;
    }

    public void setAllowedVPCs(Collection<String> allowedVPCs) {
        if (allowedVPCs == null) {
            this.allowedVPCs = null;
            return;
        }
        this.allowedVPCs = new SdkInternalList(allowedVPCs);
    }

    public RevokeEndpointAccessResult withAllowedVPCs(String ... allowedVPCs) {
        if (this.allowedVPCs == null) {
            this.setAllowedVPCs((Collection<String>)new SdkInternalList(allowedVPCs.length));
        }
        for (String ele : allowedVPCs) {
            this.allowedVPCs.add((Object)ele);
        }
        return this;
    }

    public RevokeEndpointAccessResult withAllowedVPCs(Collection<String> allowedVPCs) {
        this.setAllowedVPCs(allowedVPCs);
        return this;
    }

    public void setEndpointCount(Integer endpointCount) {
        this.endpointCount = endpointCount;
    }

    public Integer getEndpointCount() {
        return this.endpointCount;
    }

    public RevokeEndpointAccessResult withEndpointCount(Integer endpointCount) {
        this.setEndpointCount(endpointCount);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getGrantor() != null) {
            sb.append("Grantor: ").append(this.getGrantor()).append(",");
        }
        if (this.getGrantee() != null) {
            sb.append("Grantee: ").append(this.getGrantee()).append(",");
        }
        if (this.getClusterIdentifier() != null) {
            sb.append("ClusterIdentifier: ").append(this.getClusterIdentifier()).append(",");
        }
        if (this.getAuthorizeTime() != null) {
            sb.append("AuthorizeTime: ").append(this.getAuthorizeTime()).append(",");
        }
        if (this.getClusterStatus() != null) {
            sb.append("ClusterStatus: ").append(this.getClusterStatus()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getAllowedAllVPCs() != null) {
            sb.append("AllowedAllVPCs: ").append(this.getAllowedAllVPCs()).append(",");
        }
        if (this.getAllowedVPCs() != null) {
            sb.append("AllowedVPCs: ").append(this.getAllowedVPCs()).append(",");
        }
        if (this.getEndpointCount() != null) {
            sb.append("EndpointCount: ").append(this.getEndpointCount());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RevokeEndpointAccessResult)) {
            return false;
        }
        RevokeEndpointAccessResult other = (RevokeEndpointAccessResult)obj;
        if (other.getGrantor() == null ^ this.getGrantor() == null) {
            return false;
        }
        if (other.getGrantor() != null && !other.getGrantor().equals(this.getGrantor())) {
            return false;
        }
        if (other.getGrantee() == null ^ this.getGrantee() == null) {
            return false;
        }
        if (other.getGrantee() != null && !other.getGrantee().equals(this.getGrantee())) {
            return false;
        }
        if (other.getClusterIdentifier() == null ^ this.getClusterIdentifier() == null) {
            return false;
        }
        if (other.getClusterIdentifier() != null && !other.getClusterIdentifier().equals(this.getClusterIdentifier())) {
            return false;
        }
        if (other.getAuthorizeTime() == null ^ this.getAuthorizeTime() == null) {
            return false;
        }
        if (other.getAuthorizeTime() != null && !other.getAuthorizeTime().equals(this.getAuthorizeTime())) {
            return false;
        }
        if (other.getClusterStatus() == null ^ this.getClusterStatus() == null) {
            return false;
        }
        if (other.getClusterStatus() != null && !other.getClusterStatus().equals(this.getClusterStatus())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getAllowedAllVPCs() == null ^ this.getAllowedAllVPCs() == null) {
            return false;
        }
        if (other.getAllowedAllVPCs() != null && !other.getAllowedAllVPCs().equals(this.getAllowedAllVPCs())) {
            return false;
        }
        if (other.getAllowedVPCs() == null ^ this.getAllowedVPCs() == null) {
            return false;
        }
        if (other.getAllowedVPCs() != null && !other.getAllowedVPCs().equals(this.getAllowedVPCs())) {
            return false;
        }
        if (other.getEndpointCount() == null ^ this.getEndpointCount() == null) {
            return false;
        }
        return other.getEndpointCount() == null || other.getEndpointCount().equals(this.getEndpointCount());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getGrantor() == null ? 0 : this.getGrantor().hashCode());
        hashCode = 31 * hashCode + (this.getGrantee() == null ? 0 : this.getGrantee().hashCode());
        hashCode = 31 * hashCode + (this.getClusterIdentifier() == null ? 0 : this.getClusterIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getAuthorizeTime() == null ? 0 : this.getAuthorizeTime().hashCode());
        hashCode = 31 * hashCode + (this.getClusterStatus() == null ? 0 : this.getClusterStatus().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getAllowedAllVPCs() == null ? 0 : this.getAllowedAllVPCs().hashCode());
        hashCode = 31 * hashCode + (this.getAllowedVPCs() == null ? 0 : this.getAllowedVPCs().hashCode());
        hashCode = 31 * hashCode + (this.getEndpointCount() == null ? 0 : this.getEndpointCount().hashCode());
        return hashCode;
    }

    public RevokeEndpointAccessResult clone() {
        try {
            return (RevokeEndpointAccessResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

