/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.rds.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateDBSnapshotRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String dBSnapshotIdentifier;
    private String dBInstanceIdentifier;
    private ListWithAutoConstructFlag<Tag> tags;

    public CreateDBSnapshotRequest() {
    }

    public CreateDBSnapshotRequest(String dBSnapshotIdentifier, String dBInstanceIdentifier) {
        this.setDBSnapshotIdentifier(dBSnapshotIdentifier);
        this.setDBInstanceIdentifier(dBInstanceIdentifier);
    }

    public String getDBSnapshotIdentifier() {
        return this.dBSnapshotIdentifier;
    }

    public void setDBSnapshotIdentifier(String dBSnapshotIdentifier) {
        this.dBSnapshotIdentifier = dBSnapshotIdentifier;
    }

    public CreateDBSnapshotRequest withDBSnapshotIdentifier(String dBSnapshotIdentifier) {
        this.dBSnapshotIdentifier = dBSnapshotIdentifier;
        return this;
    }

    public String getDBInstanceIdentifier() {
        return this.dBInstanceIdentifier;
    }

    public void setDBInstanceIdentifier(String dBInstanceIdentifier) {
        this.dBInstanceIdentifier = dBInstanceIdentifier;
    }

    public CreateDBSnapshotRequest withDBInstanceIdentifier(String dBInstanceIdentifier) {
        this.dBInstanceIdentifier = dBInstanceIdentifier;
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new ListWithAutoConstructFlag();
            this.tags.setAutoConstruct(true);
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        ListWithAutoConstructFlag tagsCopy = new ListWithAutoConstructFlag(tags.size());
        tagsCopy.addAll(tags);
        this.tags = tagsCopy;
    }

    public CreateDBSnapshotRequest withTags(Tag ... tags) {
        if (this.getTags() == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag value : tags) {
            this.getTags().add(value);
        }
        return this;
    }

    public CreateDBSnapshotRequest withTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
        } else {
            ListWithAutoConstructFlag tagsCopy = new ListWithAutoConstructFlag(tags.size());
            tagsCopy.addAll(tags);
            this.tags = tagsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDBSnapshotIdentifier() != null) {
            sb.append("DBSnapshotIdentifier: " + this.getDBSnapshotIdentifier() + ",");
        }
        if (this.getDBInstanceIdentifier() != null) {
            sb.append("DBInstanceIdentifier: " + this.getDBInstanceIdentifier() + ",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: " + this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDBSnapshotIdentifier() == null ? 0 : this.getDBSnapshotIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getDBInstanceIdentifier() == null ? 0 : this.getDBInstanceIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDBSnapshotRequest)) {
            return false;
        }
        CreateDBSnapshotRequest other = (CreateDBSnapshotRequest)obj;
        if (other.getDBSnapshotIdentifier() == null ^ this.getDBSnapshotIdentifier() == null) {
            return false;
        }
        if (other.getDBSnapshotIdentifier() != null && !other.getDBSnapshotIdentifier().equals(this.getDBSnapshotIdentifier())) {
            return false;
        }
        if (other.getDBInstanceIdentifier() == null ^ this.getDBInstanceIdentifier() == null) {
            return false;
        }
        if (other.getDBInstanceIdentifier() != null && !other.getDBInstanceIdentifier().equals(this.getDBInstanceIdentifier())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public CreateDBSnapshotRequest clone() {
        return (CreateDBSnapshotRequest)super.clone();
    }
}

