/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.rds.model.Parameter;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ResetDBParameterGroupRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String dBParameterGroupName;
    private Boolean resetAllParameters;
    private SdkInternalList<Parameter> parameters;

    public ResetDBParameterGroupRequest() {
    }

    public ResetDBParameterGroupRequest(String dBParameterGroupName) {
        this.setDBParameterGroupName(dBParameterGroupName);
    }

    public void setDBParameterGroupName(String dBParameterGroupName) {
        this.dBParameterGroupName = dBParameterGroupName;
    }

    public String getDBParameterGroupName() {
        return this.dBParameterGroupName;
    }

    public ResetDBParameterGroupRequest withDBParameterGroupName(String dBParameterGroupName) {
        this.setDBParameterGroupName(dBParameterGroupName);
        return this;
    }

    public void setResetAllParameters(Boolean resetAllParameters) {
        this.resetAllParameters = resetAllParameters;
    }

    public Boolean getResetAllParameters() {
        return this.resetAllParameters;
    }

    public ResetDBParameterGroupRequest withResetAllParameters(Boolean resetAllParameters) {
        this.setResetAllParameters(resetAllParameters);
        return this;
    }

    public Boolean isResetAllParameters() {
        return this.resetAllParameters;
    }

    public List<Parameter> getParameters() {
        if (this.parameters == null) {
            this.parameters = new SdkInternalList();
        }
        return this.parameters;
    }

    public void setParameters(Collection<Parameter> parameters) {
        if (parameters == null) {
            this.parameters = null;
            return;
        }
        this.parameters = new SdkInternalList(parameters);
    }

    public ResetDBParameterGroupRequest withParameters(Parameter ... parameters) {
        if (this.parameters == null) {
            this.setParameters((Collection<Parameter>)new SdkInternalList(parameters.length));
        }
        for (Parameter ele : parameters) {
            this.parameters.add((Object)ele);
        }
        return this;
    }

    public ResetDBParameterGroupRequest withParameters(Collection<Parameter> parameters) {
        this.setParameters(parameters);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDBParameterGroupName() != null) {
            sb.append("DBParameterGroupName: ").append(this.getDBParameterGroupName()).append(",");
        }
        if (this.getResetAllParameters() != null) {
            sb.append("ResetAllParameters: ").append(this.getResetAllParameters()).append(",");
        }
        if (this.getParameters() != null) {
            sb.append("Parameters: ").append(this.getParameters());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResetDBParameterGroupRequest)) {
            return false;
        }
        ResetDBParameterGroupRequest other = (ResetDBParameterGroupRequest)obj;
        if (other.getDBParameterGroupName() == null ^ this.getDBParameterGroupName() == null) {
            return false;
        }
        if (other.getDBParameterGroupName() != null && !other.getDBParameterGroupName().equals(this.getDBParameterGroupName())) {
            return false;
        }
        if (other.getResetAllParameters() == null ^ this.getResetAllParameters() == null) {
            return false;
        }
        if (other.getResetAllParameters() != null && !other.getResetAllParameters().equals(this.getResetAllParameters())) {
            return false;
        }
        if (other.getParameters() == null ^ this.getParameters() == null) {
            return false;
        }
        return other.getParameters() == null || other.getParameters().equals(this.getParameters());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDBParameterGroupName() == null ? 0 : this.getDBParameterGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getResetAllParameters() == null ? 0 : this.getResetAllParameters().hashCode());
        hashCode = 31 * hashCode + (this.getParameters() == null ? 0 : this.getParameters().hashCode());
        return hashCode;
    }

    public ResetDBParameterGroupRequest clone() {
        return (ResetDBParameterGroupRequest)super.clone();
    }
}

