/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.VisualCustomActionOperation;
import com.amazonaws.services.quicksight.model.VisualCustomActionTrigger;
import com.amazonaws.services.quicksight.model.WidgetStatus;
import com.amazonaws.services.quicksight.model.transform.VisualCustomActionMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class VisualCustomAction
implements Serializable,
Cloneable,
StructuredPojo {
    private String customActionId;
    private String name;
    private String status;
    private String trigger;
    private List<VisualCustomActionOperation> actionOperations;

    public void setCustomActionId(String customActionId) {
        this.customActionId = customActionId;
    }

    public String getCustomActionId() {
        return this.customActionId;
    }

    public VisualCustomAction withCustomActionId(String customActionId) {
        this.setCustomActionId(customActionId);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public VisualCustomAction withName(String name) {
        this.setName(name);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public VisualCustomAction withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public VisualCustomAction withStatus(WidgetStatus status) {
        this.status = status.toString();
        return this;
    }

    public void setTrigger(String trigger) {
        this.trigger = trigger;
    }

    public String getTrigger() {
        return this.trigger;
    }

    public VisualCustomAction withTrigger(String trigger) {
        this.setTrigger(trigger);
        return this;
    }

    public VisualCustomAction withTrigger(VisualCustomActionTrigger trigger) {
        this.trigger = trigger.toString();
        return this;
    }

    public List<VisualCustomActionOperation> getActionOperations() {
        return this.actionOperations;
    }

    public void setActionOperations(Collection<VisualCustomActionOperation> actionOperations) {
        if (actionOperations == null) {
            this.actionOperations = null;
            return;
        }
        this.actionOperations = new ArrayList<VisualCustomActionOperation>(actionOperations);
    }

    public VisualCustomAction withActionOperations(VisualCustomActionOperation ... actionOperations) {
        if (this.actionOperations == null) {
            this.setActionOperations(new ArrayList<VisualCustomActionOperation>(actionOperations.length));
        }
        for (VisualCustomActionOperation ele : actionOperations) {
            this.actionOperations.add(ele);
        }
        return this;
    }

    public VisualCustomAction withActionOperations(Collection<VisualCustomActionOperation> actionOperations) {
        this.setActionOperations(actionOperations);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCustomActionId() != null) {
            sb.append("CustomActionId: ").append(this.getCustomActionId()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getTrigger() != null) {
            sb.append("Trigger: ").append(this.getTrigger()).append(",");
        }
        if (this.getActionOperations() != null) {
            sb.append("ActionOperations: ").append(this.getActionOperations());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VisualCustomAction)) {
            return false;
        }
        VisualCustomAction other = (VisualCustomAction)obj;
        if (other.getCustomActionId() == null ^ this.getCustomActionId() == null) {
            return false;
        }
        if (other.getCustomActionId() != null && !other.getCustomActionId().equals(this.getCustomActionId())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getTrigger() == null ^ this.getTrigger() == null) {
            return false;
        }
        if (other.getTrigger() != null && !other.getTrigger().equals(this.getTrigger())) {
            return false;
        }
        if (other.getActionOperations() == null ^ this.getActionOperations() == null) {
            return false;
        }
        return other.getActionOperations() == null || other.getActionOperations().equals(this.getActionOperations());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCustomActionId() == null ? 0 : this.getCustomActionId().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getTrigger() == null ? 0 : this.getTrigger().hashCode());
        hashCode = 31 * hashCode + (this.getActionOperations() == null ? 0 : this.getActionOperations().hashCode());
        return hashCode;
    }

    public VisualCustomAction clone() {
        try {
            return (VisualCustomAction)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        VisualCustomActionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

