/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.SnapshotFileSheetSelectionScope;
import com.amazonaws.services.quicksight.model.transform.SnapshotFileSheetSelectionMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SnapshotFileSheetSelection
implements Serializable,
Cloneable,
StructuredPojo {
    private String sheetId;
    private String selectionScope;
    private List<String> visualIds;

    public void setSheetId(String sheetId) {
        this.sheetId = sheetId;
    }

    public String getSheetId() {
        return this.sheetId;
    }

    public SnapshotFileSheetSelection withSheetId(String sheetId) {
        this.setSheetId(sheetId);
        return this;
    }

    public void setSelectionScope(String selectionScope) {
        this.selectionScope = selectionScope;
    }

    public String getSelectionScope() {
        return this.selectionScope;
    }

    public SnapshotFileSheetSelection withSelectionScope(String selectionScope) {
        this.setSelectionScope(selectionScope);
        return this;
    }

    public SnapshotFileSheetSelection withSelectionScope(SnapshotFileSheetSelectionScope selectionScope) {
        this.selectionScope = selectionScope.toString();
        return this;
    }

    public List<String> getVisualIds() {
        return this.visualIds;
    }

    public void setVisualIds(Collection<String> visualIds) {
        if (visualIds == null) {
            this.visualIds = null;
            return;
        }
        this.visualIds = new ArrayList<String>(visualIds);
    }

    public SnapshotFileSheetSelection withVisualIds(String ... visualIds) {
        if (this.visualIds == null) {
            this.setVisualIds(new ArrayList<String>(visualIds.length));
        }
        for (String ele : visualIds) {
            this.visualIds.add(ele);
        }
        return this;
    }

    public SnapshotFileSheetSelection withVisualIds(Collection<String> visualIds) {
        this.setVisualIds(visualIds);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSheetId() != null) {
            sb.append("SheetId: ").append(this.getSheetId()).append(",");
        }
        if (this.getSelectionScope() != null) {
            sb.append("SelectionScope: ").append(this.getSelectionScope()).append(",");
        }
        if (this.getVisualIds() != null) {
            sb.append("VisualIds: ").append(this.getVisualIds());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SnapshotFileSheetSelection)) {
            return false;
        }
        SnapshotFileSheetSelection other = (SnapshotFileSheetSelection)obj;
        if (other.getSheetId() == null ^ this.getSheetId() == null) {
            return false;
        }
        if (other.getSheetId() != null && !other.getSheetId().equals(this.getSheetId())) {
            return false;
        }
        if (other.getSelectionScope() == null ^ this.getSelectionScope() == null) {
            return false;
        }
        if (other.getSelectionScope() != null && !other.getSelectionScope().equals(this.getSelectionScope())) {
            return false;
        }
        if (other.getVisualIds() == null ^ this.getVisualIds() == null) {
            return false;
        }
        return other.getVisualIds() == null || other.getVisualIds().equals(this.getVisualIds());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSheetId() == null ? 0 : this.getSheetId().hashCode());
        hashCode = 31 * hashCode + (this.getSelectionScope() == null ? 0 : this.getSelectionScope().hashCode());
        hashCode = 31 * hashCode + (this.getVisualIds() == null ? 0 : this.getVisualIds().hashCode());
        return hashCode;
    }

    public SnapshotFileSheetSelection clone() {
        try {
            return (SnapshotFileSheetSelection)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SnapshotFileSheetSelectionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

