/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.quicksight.model.VisualPalette;
import java.util.List;

@SdkInternalApi
public class VisualPaletteMarshaller {
    private static final MarshallingInfo<String> CHARTCOLOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ChartColor").build();
    private static final MarshallingInfo<List> COLORMAP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ColorMap").build();
    private static final VisualPaletteMarshaller instance = new VisualPaletteMarshaller();

    public static VisualPaletteMarshaller getInstance() {
        return instance;
    }

    public void marshall(VisualPalette visualPalette, ProtocolMarshaller protocolMarshaller) {
        if (visualPalette == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)visualPalette.getChartColor(), CHARTCOLOR_BINDING);
            protocolMarshaller.marshall(visualPalette.getColorMap(), COLORMAP_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

