/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.AssignmentStatus;
import com.amazonaws.services.quicksight.model.transform.IAMPolicyAssignmentMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IAMPolicyAssignment
implements Serializable,
Cloneable,
StructuredPojo {
    private String awsAccountId;
    private String assignmentId;
    private String assignmentName;
    private String policyArn;
    private Map<String, List<String>> identities;
    private String assignmentStatus;

    public void setAwsAccountId(String awsAccountId) {
        this.awsAccountId = awsAccountId;
    }

    public String getAwsAccountId() {
        return this.awsAccountId;
    }

    public IAMPolicyAssignment withAwsAccountId(String awsAccountId) {
        this.setAwsAccountId(awsAccountId);
        return this;
    }

    public void setAssignmentId(String assignmentId) {
        this.assignmentId = assignmentId;
    }

    public String getAssignmentId() {
        return this.assignmentId;
    }

    public IAMPolicyAssignment withAssignmentId(String assignmentId) {
        this.setAssignmentId(assignmentId);
        return this;
    }

    public void setAssignmentName(String assignmentName) {
        this.assignmentName = assignmentName;
    }

    public String getAssignmentName() {
        return this.assignmentName;
    }

    public IAMPolicyAssignment withAssignmentName(String assignmentName) {
        this.setAssignmentName(assignmentName);
        return this;
    }

    public void setPolicyArn(String policyArn) {
        this.policyArn = policyArn;
    }

    public String getPolicyArn() {
        return this.policyArn;
    }

    public IAMPolicyAssignment withPolicyArn(String policyArn) {
        this.setPolicyArn(policyArn);
        return this;
    }

    public Map<String, List<String>> getIdentities() {
        return this.identities;
    }

    public void setIdentities(Map<String, List<String>> identities) {
        this.identities = identities;
    }

    public IAMPolicyAssignment withIdentities(Map<String, List<String>> identities) {
        this.setIdentities(identities);
        return this;
    }

    public IAMPolicyAssignment addIdentitiesEntry(String key, List<String> value) {
        if (null == this.identities) {
            this.identities = new HashMap<String, List<String>>();
        }
        if (this.identities.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.identities.put(key, value);
        return this;
    }

    public IAMPolicyAssignment clearIdentitiesEntries() {
        this.identities = null;
        return this;
    }

    public void setAssignmentStatus(String assignmentStatus) {
        this.assignmentStatus = assignmentStatus;
    }

    public String getAssignmentStatus() {
        return this.assignmentStatus;
    }

    public IAMPolicyAssignment withAssignmentStatus(String assignmentStatus) {
        this.setAssignmentStatus(assignmentStatus);
        return this;
    }

    public IAMPolicyAssignment withAssignmentStatus(AssignmentStatus assignmentStatus) {
        this.assignmentStatus = assignmentStatus.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAwsAccountId() != null) {
            sb.append("AwsAccountId: ").append(this.getAwsAccountId()).append(",");
        }
        if (this.getAssignmentId() != null) {
            sb.append("AssignmentId: ").append(this.getAssignmentId()).append(",");
        }
        if (this.getAssignmentName() != null) {
            sb.append("AssignmentName: ").append(this.getAssignmentName()).append(",");
        }
        if (this.getPolicyArn() != null) {
            sb.append("PolicyArn: ").append(this.getPolicyArn()).append(",");
        }
        if (this.getIdentities() != null) {
            sb.append("Identities: ").append(this.getIdentities()).append(",");
        }
        if (this.getAssignmentStatus() != null) {
            sb.append("AssignmentStatus: ").append(this.getAssignmentStatus());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IAMPolicyAssignment)) {
            return false;
        }
        IAMPolicyAssignment other = (IAMPolicyAssignment)obj;
        if (other.getAwsAccountId() == null ^ this.getAwsAccountId() == null) {
            return false;
        }
        if (other.getAwsAccountId() != null && !other.getAwsAccountId().equals(this.getAwsAccountId())) {
            return false;
        }
        if (other.getAssignmentId() == null ^ this.getAssignmentId() == null) {
            return false;
        }
        if (other.getAssignmentId() != null && !other.getAssignmentId().equals(this.getAssignmentId())) {
            return false;
        }
        if (other.getAssignmentName() == null ^ this.getAssignmentName() == null) {
            return false;
        }
        if (other.getAssignmentName() != null && !other.getAssignmentName().equals(this.getAssignmentName())) {
            return false;
        }
        if (other.getPolicyArn() == null ^ this.getPolicyArn() == null) {
            return false;
        }
        if (other.getPolicyArn() != null && !other.getPolicyArn().equals(this.getPolicyArn())) {
            return false;
        }
        if (other.getIdentities() == null ^ this.getIdentities() == null) {
            return false;
        }
        if (other.getIdentities() != null && !other.getIdentities().equals(this.getIdentities())) {
            return false;
        }
        if (other.getAssignmentStatus() == null ^ this.getAssignmentStatus() == null) {
            return false;
        }
        return other.getAssignmentStatus() == null || other.getAssignmentStatus().equals(this.getAssignmentStatus());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAwsAccountId() == null ? 0 : this.getAwsAccountId().hashCode());
        hashCode = 31 * hashCode + (this.getAssignmentId() == null ? 0 : this.getAssignmentId().hashCode());
        hashCode = 31 * hashCode + (this.getAssignmentName() == null ? 0 : this.getAssignmentName().hashCode());
        hashCode = 31 * hashCode + (this.getPolicyArn() == null ? 0 : this.getPolicyArn().hashCode());
        hashCode = 31 * hashCode + (this.getIdentities() == null ? 0 : this.getIdentities().hashCode());
        hashCode = 31 * hashCode + (this.getAssignmentStatus() == null ? 0 : this.getAssignmentStatus().hashCode());
        return hashCode;
    }

    public IAMPolicyAssignment clone() {
        try {
            return (IAMPolicyAssignment)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        IAMPolicyAssignmentMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

