/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.TableCellStyle;
import com.amazonaws.services.quicksight.model.TableTotalsPlacement;
import com.amazonaws.services.quicksight.model.TableTotalsScrollStatus;
import com.amazonaws.services.quicksight.model.TotalAggregationOption;
import com.amazonaws.services.quicksight.model.Visibility;
import com.amazonaws.services.quicksight.model.transform.TotalOptionsMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class TotalOptions
implements Serializable,
Cloneable,
StructuredPojo {
    private String totalsVisibility;
    private String placement;
    private String scrollStatus;
    private String customLabel;
    private TableCellStyle totalCellStyle;
    private List<TotalAggregationOption> totalAggregationOptions;

    public void setTotalsVisibility(String totalsVisibility) {
        this.totalsVisibility = totalsVisibility;
    }

    public String getTotalsVisibility() {
        return this.totalsVisibility;
    }

    public TotalOptions withTotalsVisibility(String totalsVisibility) {
        this.setTotalsVisibility(totalsVisibility);
        return this;
    }

    public TotalOptions withTotalsVisibility(Visibility totalsVisibility) {
        this.totalsVisibility = totalsVisibility.toString();
        return this;
    }

    public void setPlacement(String placement) {
        this.placement = placement;
    }

    public String getPlacement() {
        return this.placement;
    }

    public TotalOptions withPlacement(String placement) {
        this.setPlacement(placement);
        return this;
    }

    public TotalOptions withPlacement(TableTotalsPlacement placement) {
        this.placement = placement.toString();
        return this;
    }

    public void setScrollStatus(String scrollStatus) {
        this.scrollStatus = scrollStatus;
    }

    public String getScrollStatus() {
        return this.scrollStatus;
    }

    public TotalOptions withScrollStatus(String scrollStatus) {
        this.setScrollStatus(scrollStatus);
        return this;
    }

    public TotalOptions withScrollStatus(TableTotalsScrollStatus scrollStatus) {
        this.scrollStatus = scrollStatus.toString();
        return this;
    }

    public void setCustomLabel(String customLabel) {
        this.customLabel = customLabel;
    }

    public String getCustomLabel() {
        return this.customLabel;
    }

    public TotalOptions withCustomLabel(String customLabel) {
        this.setCustomLabel(customLabel);
        return this;
    }

    public void setTotalCellStyle(TableCellStyle totalCellStyle) {
        this.totalCellStyle = totalCellStyle;
    }

    public TableCellStyle getTotalCellStyle() {
        return this.totalCellStyle;
    }

    public TotalOptions withTotalCellStyle(TableCellStyle totalCellStyle) {
        this.setTotalCellStyle(totalCellStyle);
        return this;
    }

    public List<TotalAggregationOption> getTotalAggregationOptions() {
        return this.totalAggregationOptions;
    }

    public void setTotalAggregationOptions(Collection<TotalAggregationOption> totalAggregationOptions) {
        if (totalAggregationOptions == null) {
            this.totalAggregationOptions = null;
            return;
        }
        this.totalAggregationOptions = new ArrayList<TotalAggregationOption>(totalAggregationOptions);
    }

    public TotalOptions withTotalAggregationOptions(TotalAggregationOption ... totalAggregationOptions) {
        if (this.totalAggregationOptions == null) {
            this.setTotalAggregationOptions(new ArrayList<TotalAggregationOption>(totalAggregationOptions.length));
        }
        for (TotalAggregationOption ele : totalAggregationOptions) {
            this.totalAggregationOptions.add(ele);
        }
        return this;
    }

    public TotalOptions withTotalAggregationOptions(Collection<TotalAggregationOption> totalAggregationOptions) {
        this.setTotalAggregationOptions(totalAggregationOptions);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTotalsVisibility() != null) {
            sb.append("TotalsVisibility: ").append(this.getTotalsVisibility()).append(",");
        }
        if (this.getPlacement() != null) {
            sb.append("Placement: ").append(this.getPlacement()).append(",");
        }
        if (this.getScrollStatus() != null) {
            sb.append("ScrollStatus: ").append(this.getScrollStatus()).append(",");
        }
        if (this.getCustomLabel() != null) {
            sb.append("CustomLabel: ").append(this.getCustomLabel()).append(",");
        }
        if (this.getTotalCellStyle() != null) {
            sb.append("TotalCellStyle: ").append(this.getTotalCellStyle()).append(",");
        }
        if (this.getTotalAggregationOptions() != null) {
            sb.append("TotalAggregationOptions: ").append(this.getTotalAggregationOptions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TotalOptions)) {
            return false;
        }
        TotalOptions other = (TotalOptions)obj;
        if (other.getTotalsVisibility() == null ^ this.getTotalsVisibility() == null) {
            return false;
        }
        if (other.getTotalsVisibility() != null && !other.getTotalsVisibility().equals(this.getTotalsVisibility())) {
            return false;
        }
        if (other.getPlacement() == null ^ this.getPlacement() == null) {
            return false;
        }
        if (other.getPlacement() != null && !other.getPlacement().equals(this.getPlacement())) {
            return false;
        }
        if (other.getScrollStatus() == null ^ this.getScrollStatus() == null) {
            return false;
        }
        if (other.getScrollStatus() != null && !other.getScrollStatus().equals(this.getScrollStatus())) {
            return false;
        }
        if (other.getCustomLabel() == null ^ this.getCustomLabel() == null) {
            return false;
        }
        if (other.getCustomLabel() != null && !other.getCustomLabel().equals(this.getCustomLabel())) {
            return false;
        }
        if (other.getTotalCellStyle() == null ^ this.getTotalCellStyle() == null) {
            return false;
        }
        if (other.getTotalCellStyle() != null && !other.getTotalCellStyle().equals(this.getTotalCellStyle())) {
            return false;
        }
        if (other.getTotalAggregationOptions() == null ^ this.getTotalAggregationOptions() == null) {
            return false;
        }
        return other.getTotalAggregationOptions() == null || other.getTotalAggregationOptions().equals(this.getTotalAggregationOptions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTotalsVisibility() == null ? 0 : this.getTotalsVisibility().hashCode());
        hashCode = 31 * hashCode + (this.getPlacement() == null ? 0 : this.getPlacement().hashCode());
        hashCode = 31 * hashCode + (this.getScrollStatus() == null ? 0 : this.getScrollStatus().hashCode());
        hashCode = 31 * hashCode + (this.getCustomLabel() == null ? 0 : this.getCustomLabel().hashCode());
        hashCode = 31 * hashCode + (this.getTotalCellStyle() == null ? 0 : this.getTotalCellStyle().hashCode());
        hashCode = 31 * hashCode + (this.getTotalAggregationOptions() == null ? 0 : this.getTotalAggregationOptions().hashCode());
        return hashCode;
    }

    public TotalOptions clone() {
        try {
            return (TotalOptions)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TotalOptionsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

